//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndTga.h
 * @brief		tga t@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndTga_H_
#define INCG_IRIS_FndTga_H_

//======================================================================
// include
#include "FndImage.h"
#include "FndColorExchange.h"

namespace iris {
namespace fnd
{

//======================================================================
// struct
#include "../../misc/iris_pushpack1.h"
/// tgat@Cwb_
typedef struct tagTGA_HEADER
{
	u8	IDLength;			//!< IDtB[h
	u8	ColorMapType;		//!< J[}bv̗L
	u8	ImageType;			//!< 摜`

	u16	ColorMapFirstNo;	//!< J[}bv̊Jnԍ
	u16	ColorMapNum;		//!< J[}bv̌
	u8	ColorMapBit;		//!< J[}bṽrbg

	u16	OriginX;			//!< 摜XW
	u16	OriginY;			//!< 摜YW

	u16	Width;				//!< 摜̉
	u16	Height;				//!< 摜̏c

	u8	PixelDepth;			//!< F[x
	u8	ImageDesc;			//!< ̑̏(0~3: 4:i[u 5:i[v 6,7:C^[[u)
} TGA_HEADER, *LPTGA_HEADER;	//!< tgat@Cwb_
typedef const TGA_HEADER	*LPCTGA_HEADER;
#include "../../misc/iris_poppack.h"

/// tgat@Ctb^[
#include "../../misc/iris_pushpack2.h"
typedef IRIS_PACKED struct tagTGA_FOOTER
{
	u32		ExtOffset;	//!< gGÃItZbg
	u32		DevOffset;	//!< JGÃItZbg
	u8		Sign[17];	//!< TRUEVISION-xxxxx.
	u8		RFU;		//!< 0
} TGA_FOOTER, *LPTGA_FOOTER;	//!< tgat@Ctb^[
#include "../../misc/iris_poppack.h"

//======================================================================
// enum
/// tga C[W^Cv
typedef enum TGA_IMAGETYPE
{
	TGA_IMAGETYPE_NONE		= 0x00,	//!< C[WȂ
	TGA_IMAGETYPE_INDEX		= 0x01,	//!< CfbNXJ[(256F)
	TGA_IMAGETYPE_FULL		= 0x02,	//!< tJ[
	TGA_IMAGETYPE_GRAY		= 0x03,	//!< 

	TGA_IMAGETYPE_INDEX_RLE	= 0x09,	//!< CfbNXJ[(256F)(RLEk)
	TGA_IMAGETYPE_FULL_RLE	= 0x0a,	//!< tJ[(RLEk)
	TGA_IMAGETYPE_GRAY_RLE	= 0x0b	//!< (RLEk)

} TGA_IMAGETYPE;

/// sNZi[
typedef enum TGA_PIXEL_PUTDIRECTION
{
	TGA_PPD_RIGHT		= 0x1,	//!< E獶
	TGA_PPD_TOP			= 0x2,	//!< ォ牺

	TGA_PPD_LEFT_TOP	= 0x0,	//!< E
	TGA_PPD_RIGHT_TOP	= 0x1,	//!< E獶
	TGA_PPD_LEFT_DOWN	= 0x2,	//!< ォE
	TGA_PPD_RIGHT_DOWN	= 0x3,	//!< Eォ獶

	TGA_PPD_MASK		= 0x3	//!< rbg}XN
} TGA_PIXEL_PUTDIRECTION;

//======================================================================
// class
/// tgaNX
class CTga : public IImage
{
protected:
	// tgat@Cf[^
	u8*		m_pBuffer;
	u32		m_Size;
public:
	// RXgN^
	CTga(void);
	// fXgN^
	virtual ~CTga(void);

public:
	// t@C̃[h
	template<typename CHARTYPE_>
	bool	ReadFile (const CHARTYPE_* lpFileName);
	bool	ReadFileA(LPCSTR  lpFileName);
	bool	ReadFileW(LPCWSTR lpFileName);

	// t@Cɏ
	template<typename CHARTYPE_>
	bool	WriteFile (const CHARTYPE_* lpFileName);
	bool	WriteFileA(LPCSTR  lpFileName);
	bool	WriteFileW(LPCWSTR lpFileName);

	// 
	void	Release(void);

public:
	// Rs[
	bool	Duplicate(CTga& tga);

public:
	/// LȃC[Wǂ
	virtual bool		IsValid(void)		const;
	// obt@̎擾
	const u8*			GetBuffer(void)		const;
	/// obt@TCY̎擾
	u32					GetBufferSize(void)	const	{ return m_Size; }
	// t@Cwb_̎擾
	LPCTGA_HEADER		GetHeader(void)		const;
	// pbg̗L
	u8					IsHasPalette(void)	const;
	// pbgf[^̎擾
	const u8*			GetPalette(void)	const;
	// pbgf[^TCY̎擾
	u32					GetPaletteSize(void)	const;
	// CfbNXf[^̎擾
	const u8*			GetIndex(void)		const;
	// CfbNXf[^TCY̎擾
	u32					GetIndexSize(void)	const;
	// C[Wf[^̎擾
	const u8*			GetImage(void)		const;
	// C[Wf[^TCY̎擾
	u32					GetImageSize(void)	const;
	// [x擾
	u8					GetPixelDepth(void)	const;
	// J[f[^bit擾
	u8					GetColorMapBits(void)	const;
	// ̎擾
	virtual s32			GetWidth(void)		const;
	// c̎擾
	virtual s32			GetHeight(void)		const;
	// C[W^Cv̎擾
	u8					GetImageType(void)	const;
	// sNZf[^̊i[擾
	u8					GetPixelPutDirection(void)	const;

public:
	// 1pixel̃oCg擾
	int					GetBytePerPixel(void)	const;
	// wWpixelf[^̎擾
	void*				GetPixel(int x, int y)	const;

public:
	// sNZJ[̎擾
	virtual bool		GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const;
	// sNZJ[̐ݒ
	virtual bool		SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba);

public:
	// obt@ɓWJ
	virtual	bool	CreateImage(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	// TGA_IMAGETYPE_INDEXobt@ɓWJ
	bool	CreateImageFromIndex  (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromIndex8 (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromIndex16(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	// TGA_IMAGETYPE_FULLobt@ɓWJ
	bool	CreateImageFromFullColor  (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromFullColor16(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromFullColor24(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromFullColor32(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	// TGA_IMAGETYPE_GRAYobt@ɓWJ
	bool	CreateImageFromGray  (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromGray8 (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromGray16(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;

	// TGA_IMAGETYPE_INDEX_RLEobt@ɓWJ
	bool	CreateImageFromIndexRLE(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	// TGA_IMAGETYPE_FULL_RLEobt@ɓWJ
	bool	CreateImageFromFullColorRLE  (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromFullColorRLE16(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromFullColorRLE24(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromFullColorRLE32(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	// TGA_IMAGETYPE_GRAYobt@ɓWJ
	bool	CreateImageFromGrayRLE  (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromGrayRLE8 (void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;
	bool	CreateImageFromGrayRLE16(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;

protected:
	// obt@̃m
	void	Alloc(u32 size, s32 arg);
	// obt@̃
	void	Dealloc(void);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
