//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndPng.h
 * @brief		png t@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndPng_H_
#define INCG_IRIS_FndPng_H_

//======================================================================
// include
#include "FndImage.h"

//
#ifdef _IRIS_SUPPORT_PNG
#  if	defined(_MT) && defined(_DLL)
//#      pragma IRIS_MSG_TODO("_IRIS_SUPPORT_PNG /MD or /MDd RpC͌ΉłB")
#      undef _IRIS_SUPPORT_PNG
#  endif
#endif

#ifdef _IRIS_SUPPORT_PNG

IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4668)	// '#if/#elif'  '0' ɒuvvZbT }NƂĒ`Ă܂B
#include <png.h>
IRIS_MSC_PRAGMA_WARNING_END()

namespace iris {
namespace fnd
{

//======================================================================
// class
/// png NX
class CPng : public IImage
{
protected:
	u8*		m_pBuffer;	//!< t@Cobt@
	u32		m_Size;		//!< obt@TCY
	png_uint_32		m_Width;	//!< 
	png_uint_32		m_Height;	//!< c
public:
	// RXgN^
	CPng(void);
	// fXgN^
	~CPng(void);

public:
	// t@Cǂݍ
	template<typename CHARTYPE_>
	bool	ReadFile(const CHARTYPE_* lpFileName);

	// 
	void	Release(void);

public:
	// Rs[
	bool	Duplicate(CPng& png);

public:
	// obt@ɓWJ
	virtual	bool	CreateImage(void* pBuffer, PIXEL_FORMAT nPixelFormat, int nLineAlign=1, int nOrder=PPD_LEFT_DOWN) const;

public:
	// sNZJ[̎擾
	virtual bool	GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const;
	// sNZJ[̐ݒ
	virtual bool	SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba);

public:
	/// LȃC[Wǂ
	virtual bool	IsValid(void)		const;
	/// obt@AhX̎擾
	u8*				GetBuffer(void)				{ return m_pBuffer; }
	const u8*		GetBuffer(void)		const	{ return m_pBuffer; }
	/// obt@TCY̎擾
	u32				GetBufferSize(void)	const	{ return m_Size; }
	/// ̎擾
	virtual	s32		GetWidth(void)		const	{ return static_cast<s32>(m_Width); }
	/// c̎擾
	virtual	s32		GetHeight(void)		const	{ return static_cast<s32>(m_Height); }

protected:
	// tH[}bg̓ǂݍ
	bool	ReadFormat(void);
	// obt@̃m
	void	Alloc(u32 size, s32 arg);
	// obt@̃
	void	Dealloc(void);

protected:
	// pngf[^ǂݎR[obN֐
	static void	ReadCallbackFunc(png_structp lpPng, png_bytep lpBuffer, png_size_t size);

};


}	// end of namespace fnd
}	// end of namespace iris

#endif

#endif
