//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndHSV.h
 * @brief		HSV t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndHSV_H_
#define INCG_IRIS_FndHSV_H_

//======================================================================
// include
#include "FndColor.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	HSV J[NX
*/
class CHSV : public IIrisObject
{
public:
	f32	m_h;	//!< F
	f32	m_s;	//!< ʓx
	f32 m_v;	//!< x
public:
	/**
	 * @brief	RXgN^
	 * @{
	*/
	CHSV(void) : m_h(0), m_s(0), m_v(0) {}
	CHSV(f32 h, f32 s, f32 v) : m_h(y), m_s(u), m_v(v) {}
	CHSV(const IrisFColor& col) { cast_from_fcolor(col); }
	/**
	 * @}
	*/

public:
	operator IrisFColor (void)	const	{ IrisFColor col; cast_to_fcolor(col); return col; }

protected:
	/**
	 * @ϊ
	 * @{
	*/
	void	cast_from_fcolor(const IrisFColor& col)
	{
		f32 lo = min(col.r, col.g, col.b);
		f32 hi = max(col.r, col.g, col.b);
		m_v = hi;
		if( m_v > 0.0f )
		{
			f32 diff = (hi - lo);
			m_s = diff / hi;

			f32 r = (hi - col.r) / diff;
			f32 g = (hi - col.g) / diff;
			f32 b = (hi - col.b) / diff;

			if( hi == col.r )
				m_h = 60.0f * (b - g);
			else if( hi == col.g )
				m_h = 60.0f * (r - b) + 120.0f;
			else
				m_h = 60.0f * (g - r) + 240.0f;
			if( m_h < 0.0f ) m_h += 360.0f;
		}
		else
		{
			m_h = m_s = 0.0f;
		}
	}
	void	cast_to_fcolor(IrisFColor& col) const
	{
		if( m_s > 0.0f )
		{
			int i = static_cast<int>(m_h / 60);
			f32 f = m_h / 60 - i;
			f32 m = m_v * (1.0f - m_s);
			f32 n = m_v * (1.0f - m_s * f);
			f32 k = m_v * (1.0f - m_s * (1.0f - f));

			switch(i)
			{
			case 0:
				col.r = m_v, col.g = k; col.b = m;
				break;
			case 1:
				col.r = n, col.g = m_v; col.b = m;
				break;
			case 2:
				col.r = m, col.g = m_v; col.b = k;
				break;
			case 3:
				col.r = m, col.g = n; col.b = m_v;
				break;
			case 4:
				col.r = k, col.g = m; col.b = m_v;
				break;
			case 5:
				col.r = m_v, col.g = m; col.b = n;
				break;
			}
		}
		else
		{
			col.r = col.g = col.b = m_v;
		}
	}
	/**
	 * @}
	*/
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
