//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndColorExchange.cpp
 * @brief		bsd_template t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndColorExchange_CPP_

//======================================================================
// include
#include "FndColorExchange.h"

namespace iris {
namespace fnd
{

/**********************************************************************//**
 *
 * Fϊ֐̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nSrcPixelFormat	= ̓XJ[̃tH[}bg
 * @param [in]	nDstPixelFormat	= o̓J[̃tH[}bg
 * @param [in]	lpDstSize		= o̓J[̃oCgTCY
 * @return	֐|C^
*//***********************************************************************/
CColorExchange::PFN_COLOR_FORMAT_EXCHANGE CColorExchange::GetColorFormatExchange(IImage::PIXEL_FORMAT nSrcPixelFormat, IImage::PIXEL_FORMAT nDstPixelFormat
																 , int* lpDstSize)
{
	static const PFN_COLOR_FORMAT_EXCHANGE list[IImage::PF_NUM][IImage::PF_NUM] = {
		{
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA8   >::type, IImage::Format<IImage::PF_LA8     >::type>,
		},
		{
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_BGRA8   >::type, IImage::Format<IImage::PF_LA8     >::type>,
		},
		{
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_RGB8    >::type, IImage::Format<IImage::PF_LA8     >::type>,
		},
		{
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_BGR8    >::type, IImage::Format<IImage::PF_LA8     >::type>,
		},
		{
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA4   >::type, IImage::Format<IImage::PF_LA8     >::type>,
		},
		{
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_RGBA5551>::type, IImage::Format<IImage::PF_LA8     >::type>,
		},
		{
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_RGB565  >::type, IImage::Format<IImage::PF_LA8     >::type>,
		},
		{
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_L8      >::type, IImage::Format<IImage::PF_LA8     >::type>,
		},
		{
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_RGBA8   >::type>,
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_BGRA8   >::type>,
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_RGB8    >::type>,
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_BGR8    >::type>,
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_RGBA4   >::type>,
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_RGBA5551>::type>,
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_RGB565  >::type>,
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_L8      >::type>,
			Exchange< IImage::Format<IImage::PF_LA8     >::type, IImage::Format<IImage::PF_LA8     >::type>,
		}
	};
	if( lpDstSize != nullptr )	*lpDstSize = IImage::GetTexelSize(nDstPixelFormat);
	return list[nDstPixelFormat][nSrcPixelFormat];
}

}	// end of namespace fnd
}	// end of namespace iris
