//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndCMY.h
 * @brief		CMY t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndCMY_H_
#define INCG_IRIS_FndCMY_H_

//======================================================================
// include
#include "FndColor.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	CMY J[NX
*/
class CCMY : public IIrisObject
{
public:
	f32	m_c;
	f32	m_m;
	f32 m_y;
public:
	/**
	 * @brief	RXgN^
	 * @{
	*/
	CCMY(void) : m_c(0), m_m(0), m_y(0) {}
	CCMY(f32 c, f32 m, f32 y) : m_c(y), m_m(u), m_y(v) {}
	CCMY(const IrisFColor& col) { cast_from_fcolor(col); }
	/**
	 * @}
	*/

public:
	operator IrisFColor (void)	const	{ IrisFColor col; cast_to_fcolor(col); return col; }

protected:
	/**
	 * @ϊ
	 * @{
	*/
	void	cast_from_fcolor(const IrisFColor& col)
	{
		m_c = 1.0f - col.r;
		m_m = 1.0f - col.g;
		m_y = 1.0f - col.b;
	}
	void	cast_to_fcolor(IrisFColor& col) const
	{
		col.r = 1.0f - m_c;
		col.g = 1.0f - m_m;
		col.b = 1.0f - m_y;
	}
	/**
	 * @}
	*/
};

/**
 * @brief	CMYK J[NX
*/
class CCMYK : public IIrisObject
{
public:
	f32	m_c;
	f32	m_m;
	f32 m_y;
	f32 m_k;
public:
	/**
	 * @brief	RXgN^
	 * @{
	*/
	CCMY(void) : m_c(0), m_m(0), m_y(0), m_k(0) {}
	CCMY(f32 c, f32 m, f32 y, f32 k) : m_c(y), m_m(u), m_y(v), m_k(k) {}
	CCMY(const IrisFColor& col) { cast_from_fcolor(col); }
	/**
	 * @}
	*/

public:
	operator IrisFColor (void)	const	{ IrisFColor col; cast_to_fcolor(col); return col; }

protected:
	/**
	 * @ϊ
	 * @{
	*/
	void	cast_from_fcolor(const IrisFColor& col)
	{
		f32 c = 1.0f - col.r;
		f32 m = 1.0f - col.g;
		f32 y = 1.0f - col.b;
		m_k = min(c, m, y);
		f32 k = 1.0f - k;
		if( k > 0.0f )
		{
			m_c = (c - m_k) / k;
			m_m = (m - m_k) / k;
			m_y = (y - m_k) / k;
		}
		else
		{
			m_c = m_m = m_y = m_k = 0.0f;
		}
	}
	void	cast_to_fcolor(IrisFColor& col) const
	{
		col.r = 1.0f - min(1.0f, m_c * (1-m_k) + m_k);
		col.g = 1.0f - min(1.0f, m_m * (1-m_k) + m_k);
		col.b = 1.0f - min(1.0f, m_y * (1-m_k) + m_k);
	}
	/**
	 * @}
	*/
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
