//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBitmap555.cpp
 * @brief		bitmapNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndBitmap555_CPP_

//======================================================================
// include
#include "FndBitmap555.h"
#include <string.h>
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CBitmap555::CBitmap555(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CBitmap555::~CBitmap555(void)
{
}

/**********************************************************************//**
 *
 * t@Cǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
/// CBitmap555::ReadFile Q
bool CBitmap555::ReadFileA(LPCSTR  lpFileName)
{
	CBitmap bmp;
	if( bmp.ReadFileA(lpFileName) )
	{
		Duplicate(bmp);
	}
	else
	{
	}
	return true;
}
/// CBitmap555::ReadFile Q
bool CBitmap555::ReadFileW(LPCWSTR lpFileName)
{
	CBitmap bmp;
	if( bmp.ReadFileW(lpFileName) )
	{
		Duplicate(bmp);
	}
	else
	{
	}
	return true;
}

/**********************************************************************//**
 *
 * obt@ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @return	
*//***********************************************************************/
bool CBitmap555::ReadOnMemory(const void* lpBuffer)
{
	u8* buf = static_cast<u8*>(const_cast<void*>(lpBuffer));
	LPBMPFILEHEADER header;
	header = pointer_cast<LPBMPFILEHEADER>(buf);
	if( header->bfType != BITMAP_FILEHEAD_TYPE ) return false;
	LPBMPINFOHEADER info = pointer_cast<LPBMPINFOHEADER>(buf+sizeof(BMPFILEHEADER));
	if( info->biCompression != BI_BMP555 ) return false;
	Release();
	m_bmp.file		= header;
	m_bmp.info		= info;
	m_bmp.data		= buf+BMP_HEADSIZE;
	m_bmp.pallete	= ((m_bmp.file->bfOffBits - BMP_HEADSIZE) == 0) ? nullptr : pointer_cast<IrisRGBQUAD*>(m_bmp.data);
	m_bmp.pixel		= m_bmp.data + m_bmp.file->bfOffBits - BMP_HEADSIZE;
	m_bAllocated	= false;
	return true;
}

/**********************************************************************//**
 *
 * rbg}bṽRs[
 *
 -----------------------------------------------------------------------
 * @param [in]	rBitmap	= Rs[rbg}bv
 * @return	
*//***********************************************************************/
bool CBitmap555::Duplicate(CBitmap& rBitmap)
{
	if( !rBitmap.IsValid() ) return false;
	s32 w = rBitmap.GetWidth();
	s32 h = rBitmap.GetHeight();
	u32 size = static_cast<u32>(BMP_HEADSIZE + w * h * 2);
	if( !Alloc(size) ) return false;
	memcpy(m_bmp.file, rBitmap.GetFileHeader(), BMP_HEADSIZE);
	m_bmp.info->biCompression	= BI_BMP555;
	m_bmp.info->biSizeImage		= static_cast<u32>(w * h * 2);
	m_bmp.info->biBitCount		= 16;
	m_bmp.file->bfSize = size;

	IrisBGR555* data = pointer_cast<IrisBGR555*>(m_bmp.data);
	IrisRGBQUAD rgb;
	for( int y=0; y < h; ++y )
	{
		for( int x=0; x < w; ++x, ++data )
		{
			rBitmap.GetPixelRGBQUAD(x, y, rgb);
			data->r = rgb.r >> 3;
			data->g = rgb.g >> 3;
			data->b = rgb.b >> 3;
			data->reserved = 1u;
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * rbg}bṽRs[
 *
 -----------------------------------------------------------------------
 * @param [in]	rBitmap	= Rs[rbg}bv
 * @return	
*//***********************************************************************/
bool CBitmap555::Exchange(CBitmap& rBitmap, u32 color)
{
	if( !rBitmap.IsValid() ) return false;
	s32 w = rBitmap.GetWidth();
	s32 h = rBitmap.GetHeight();
	u32 size = static_cast<u32>(BMP_HEADSIZE + w * h * 2);
	if( !Alloc(size) ) return false;
	memcpy(m_bmp.file, rBitmap.GetFileHeader(), BMP_HEADSIZE);
	m_bmp.info->biCompression	= BI_BMP555;
	m_bmp.info->biSizeImage		= static_cast<u32>(w * h * 2);
	m_bmp.info->biBitCount		= 16;
	m_bmp.file->bfSize = size;

	IrisBGR555* data = pointer_cast<IrisBGR555*>(m_bmp.data);
	IrisRGBQUAD rgb;
	for( int y=0; y < h; ++y )
	{
		for( int x=0; x < w; ++x, ++data )
		{
			rBitmap.GetPixelRGBQUAD(x, y, rgb);
			data->r = rgb.r >> 3;
			data->g = rgb.g >> 3;
			data->b = rgb.b >> 3;
			data->reserved = rgb.col == color ? 0u : 1u;
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * obt@Rs[
 *
 -----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	size		= obt@TCY
 * @return	
*//***********************************************************************/
bool CBitmap555::DuplicateOnMemory(const void* lpBuffer, u32 size)
{
	IRIS_ASSERT( 0 );
	Release();
	if( !Alloc(size) ) return false;
	u8* buf = pointer_cast<u8*>(m_bmp.file);
	memcpy(buf, lpBuffer, size);
	m_bmp.info = pointer_cast<LPBMPINFOHEADER>(buf+sizeof(BMPFILEHEADER));
	m_bmp.data = buf + BMP_HEADSIZE;
	u32 ofs = m_bmp.file->bfOffBits - BMP_HEADSIZE;
	m_bmp.pixel = m_bmp.data + ofs;
	m_bmp.pallete = pointer_cast<IrisRGBQUAD*>(ofs == 0 ? nullptr : m_bmp.data);
	return true;
}

/**********************************************************************//**
 *
 * sNZf[^̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @return	sNZf[^
*//***********************************************************************/
void* CBitmap555::GetPixel(s32 x, s32 y) const
{
	if( !IsValid() ) return nullptr;
	s32 w = m_bmp.info->biWidth;
	s32 h = m_bmp.info->biHeight;
	if( x >= w ) return nullptr;
	if( y >= h ) return nullptr;
	s32 dy = h-y-1;
	u32 lw;
	switch( m_bmp.info->biBitCount )
	{
	case 1:
		lw = IRIS_RoundUp4B((w+7)>>3);
		x >>= 3;
		break;
	case 4:
		lw = IRIS_RoundUp4B((w+1)>>1);
		x >>= 1;
		break;
	case 8:
		lw = IRIS_RoundUp4B(w);
		break;
	case 16:
		lw = IRIS_RoundUp4B(w*2);
		x <<= 1;
		break;
	case 24:
		lw = IRIS_RoundUp4B(w*3);
		x *= 3;
		break;
	case 32:
		lw = IRIS_RoundUp4B(w*4);
		x <<= 2;
		break;
	default:
		return nullptr;
	}
	return m_bmp.pixel + lw * dy + x;
}

/**********************************************************************//**
 *
 * sNZobt@̎擾
 *
 -----------------------------------------------------------------------
 * @return	sNZobt@
*//***********************************************************************/
void* CBitmap555::GetPixel(void) const
{
	return m_bmp.pixel;
}

/**********************************************************************//**
 *
 * sNZ̐F̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pDst	= o
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @return	
*//***********************************************************************/
bool CBitmap555::GetPixelRGBQUAD(s32 x, s32 y, IrisRGBQUAD& rgbq) const
{
	void* pixel = GetPixel(x, y);
	if( pixel == nullptr ) return false;
	int idx = 0;
	switch( m_bmp.info->biBitCount )
	{
	case 1:
		idx = (*(u8*)(pixel) >> (x & 0x7)) & 0x1;
		rgbq = *(m_bmp.pallete + idx);
		break;
	case 4:
		idx = (*(u8*)(pixel) >> ((x & 0x1) << 2)) & 0xF;
		rgbq = *(m_bmp.pallete + idx);
		break;
	case 8:
		idx = *(u8*)pixel;
		rgbq = *(m_bmp.pallete + idx);
		break;
	case 16:
		idx = *(u16*)pixel;
		rgbq = *(m_bmp.pallete + idx);
		break;
	case 24:
		{
			IrisBGR888* tmp = (IrisBGR888*)pixel;
			rgbq.r = tmp->r;
			rgbq.g = tmp->g;
			rgbq.b = tmp->b;
			rgbq.Re = 0u;
		}
		break;
	case 32:
		{
			rgbq = *(IrisRGBQUAD*)(pixel);
		}
		break;
	default:
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * sNZ̐F̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pDst	= o
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @return	
*//***********************************************************************/
bool CBitmap555::SetPixelRGBQUAD(s32 x, s32 y, const IrisRGBQUAD& rgbq)
{
	void* pixel = GetPixel(x, y);
	if( pixel == nullptr ) return false;
	int idx = 0;
	switch( m_bmp.info->biBitCount )
	{
	case 1:
		idx = (*(u8*)(pixel) >> (x & 0x7)) & 0x1;
		*(m_bmp.pallete + idx) = rgbq;
		break;
	case 4:
		idx = (*(u8*)(pixel) >> ((x & 0x1) << 2)) & 0xF;
		*(m_bmp.pallete + idx) = rgbq;
		break;
	case 8:
		idx = *(u8*)pixel;
		*(m_bmp.pallete + idx) = rgbq;
		break;
	case 16:
		idx = *(u16*)pixel;
		*(m_bmp.pallete + idx) = rgbq;
		break;
	case 24:
		{
			IrisBGR888* tmp = (IrisBGR888*)pixel;
			tmp->r = rgbq.r;
			tmp->g = rgbq.g;
			tmp->b = rgbq.b;
		}
		break;
	case 32:
		{
			*(IrisRGBQUAD*)(pixel) = rgbq;
		}
		break;
	default:
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * pbg̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	idx = pbgCfbNX
 * @return	sNZf[^
*//***********************************************************************/
IrisRGBQUAD* CBitmap555::GetPallete(u32 idx) const
{
	IRIS_UNUSED_VARIABLE(idx);
	return nullptr;
}

/**********************************************************************//**
 *
 * pbgobt@̎擾
 *
 -----------------------------------------------------------------------
 * @return	pbgobt@
*//***********************************************************************/
IrisRGBQUAD* CBitmap555::GetPallete(void) const
{
	return nullptr;
}

/**********************************************************************//**
 *
 * pbǧ擾
 *
 -----------------------------------------------------------------------
 * @return	pbg
*//***********************************************************************/
u32 CBitmap555::GetPalleteNum(void) const
{
	return 0;
}

/**********************************************************************//**
 *
 * pbg̃TCY擾
 *
 -----------------------------------------------------------------------
 * @return	pbgTCY
*//***********************************************************************/
u32 CBitmap555::GetPalleteSize(void) const
{
	return 0;
}

/**********************************************************************//**
 *
 * sNZJ[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @return	sNZRGBA
*//***********************************************************************/
bool CBitmap555::GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const
{
	IrisRGBQUAD tmp;
	if( !GetPixelRGBQUAD(x, y, tmp) ) return false;
	rgba.r = tmp.r;
	rgba.g = tmp.g;
	rgba.b = tmp.b;
	rgba.a = 0xFF;
	return true;
}

/**********************************************************************//**
 *
 * sNZJ[̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	x		= xW
 * @param [in]	y		= yW
 * @param [in]	rgba	= sNZRGBA
*//***********************************************************************/
bool CBitmap555::SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba)
{
	IrisRGBQUAD tmp;
	tmp.r = rgba.r;
	tmp.g = rgba.g;
	tmp.b = rgba.b;
	return SetPixelRGBQUAD(x, y, tmp);
}

}	// end of namespace fnd
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "iris_using.h"
#include "../../iris_iostream.h"
#include <stdio.h>
#include <string.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CFndBitmap555UnitTest, Func)
{
	CBitmap bitmap;
	CBitmap555 out;
	TCHAR path[MAX_PATH] = TEXT("../../../data/image/sample.bmp");
	TCHAR out_path[MAX_PATH];
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "Jbitmapt@C͂ĂB" << std::endl;
	std::tcin >> path;
#endif

	if( !bitmap.ReadFile(path) )
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}

	_tcscpy_s(out_path, MAX_PATH, path);
	_tcscat_s(out_path, MAX_PATH, IRIS_TEXT(".dcbmp"));
	if( out.Duplicate(bitmap) )
	{
		out.WriteFile(out_path);
	}
}

#endif
