//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA512.h
 * @brief		SHA512 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSHA512_H_
#define INCG_IRIS_FndSHA512_H_

//======================================================================
// include
#include "FndHash.h"
#include "../../math/hash/MathSHA512.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// SHA512 nbVNX
class CSHA512 : public IHash
{
public:
	static const int HASHSIZE	= math::SHA512_HASHSIZE;
	typedef math::SHA512CONTEXT	CONTEXT;
protected:
	CONTEXT		m_Context;	//!< ReLXg

public:
	// RXgN^
	CSHA512(void);
	CSHA512(const u8* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN>
	CSHA512(const TN* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN, size_t SIZE>
	CSHA512(const TN (&lpBuffer)[SIZE])			{ Encode<TN, SIZE>(lpBuffer); }
	// fXgN^
	virtual ~CSHA512(void);
public:

	// 
	virtual void	Init(void);
	// NA
	virtual void	Clear(void);
	// XV
	virtual void	Update(const u8* lpBuffer, size_t uLength);
	// ŏIXV
	virtual void	Final(void);
	// nbV̏o
	virtual void	GetDigest(u8* lpBuffer)	const;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize, u8* lpBuffer)	const;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize, u8* lpBuffer)	const;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize)	const;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize)	const;
	// nbVTCY̎擾
	virtual u32		GetHashSize(void)	const	{ return HASHSIZE; }

public:
	// ReLXg̎擾
	const CONTEXT&	GetContext(void)	const	{ return m_Context; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
