//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA512.cpp
 * @brief		SHA512 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndSHA512_CPP_

//======================================================================
// include
#include "FndSHA512.h"

namespace iris {
namespace fnd
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSHA512::CSHA512(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSHA512::~CSHA512(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CSHA512::Init(void)
{
	math::SHA512InitContext(&m_Context);
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void CSHA512::Clear(void)
{
	math::SHA512ClearContext(&m_Context);
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@
*//***********************************************************************/
void CSHA512::Update(const u8* lpBuffer, size_t uLength)
{
	math::SHA512Update(&m_Context, lpBuffer, uLength);
}

/**********************************************************************//**
 *
 * ŏIXV
 *
*//***********************************************************************/
void CSHA512::Final(void)
{
	math::SHA512Final(&m_Context);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void CSHA512::GetDigest(u8* lpBuffer)	const
{
	math::SHA512Output(&m_Context, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CSHA512::ToStringA(LPSTR  lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA512ToStringA(lpString, uSize, lpBuffer);
}
void CSHA512::ToStringW(LPWSTR lpString, size_t uSize, u8* lpBuffer)	const
{
	math::SHA512ToStringW(lpString, uSize, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
*//***********************************************************************/
void CSHA512::ToStringA(LPSTR  lpString, size_t uSize)	const
{
	_ToStringA<HASHSIZE>(lpString, uSize);
}
void CSHA512::ToStringW(LPWSTR lpString, size_t uSize)	const
{
	_ToStringW<HASHSIZE>(lpString, uSize);
}

}	// end of namespace fnd
}	// end of namespace iris

#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"
#include "FndSHA.h"

TEST(CFndSHA512Test, Function)
{
	CHAR comm[256] = "";
	CSHA<512>::type sha;

	// TEST1
	strcpy_s(comm, 256, "abc");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"ddaf35a193617aba" "cc417349ae204131"
		"12e6fa4e89a97ea2" "0a9eeee64b55d39a"
		"2192992a274fc1a8" "36ba3c23a3feebbd"
		"454d4423643ce80e" "2a9ac94fa54ca49f"
		, comm );

	// TEST2
	strcpy_s(comm, 256, "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmn"
		"hijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu");
	sha.Encode(comm, strlen(comm));
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"8e959b75dae313da" "8cf4f72814fc143f"
		"8f7779c6eb9f7fa1" "7299aeadb6889018"
		"501d289e4900f7e4" "331b99dec4b5433a"
		"c7d329eeb6dd2654" "5e96e55b874be909"
		, comm );

	// TEST3
	strcpy_s(comm, 256, "a");
	sha.Init();
	for( int i=0; i < 1000000; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"e718483d0ce76964" "4e2e42c7bc15b463"
		"8e1f98b13b204428" "5632a803afa973eb"
		"de0ff244877ea60a" "4cb0432ce577c31b"
		"eb009c5c2c49aa2e" "4eadb217ad8cc09b"
		, comm );

	// TEST4
	strcpy_s(comm, 256, "01234567012345670123456701234567""01234567012345670123456701234567");
	sha.Init();
	for( int i=0; i < 10; ++i )
		sha.Update((const u8*)comm, strlen(comm));
	sha.Final();
	sha.ToStringA(comm, 256);
	ASSERT_STREQ(
		"89d05ba632c699c3" "1231ded4ffc127d5"
		"a894dad412c0e024" "db872d1abd2ba814"
		"1a0f85072a9be1e2" "aa04cf33c765cb51"
        "0813a39cd5a84c4a" "caa64d3f3fb7bae9"
		, comm );
}

#endif	// #if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
