//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA.h
 * @brief		SHA NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSHA_H_
#define INCG_IRIS_FndSHA_H_

//======================================================================
// include
#include "FndSHA1.h"
#include "FndSHA160.h"
#include "FndSHA224.h"
#include "FndSHA256.h"
#include "FndSHA384.h"
#include "FndSHA512.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// SHA nbVNX
template<int SHA>
class CSHA : public IIrisObject
{
	template<int N, typename DMY>
	struct _selector {};

	template<typename DMY>
	struct _selector<1, DMY>
	{
		typedef CSHA1	type;
	};
	template<typename DMY>
	struct _selector<160, DMY>
	{
		typedef CSHA160	type;
	};
	template<typename DMY>
	struct _selector<224, DMY>
	{
		typedef CSHA224	type;
	};
	template<typename DMY>
	struct _selector<256, DMY>
	{
		typedef CSHA256	type;
	};
	template<typename DMY>
	struct _selector<384, DMY>
	{
		typedef CSHA384	type;
	};
	template<typename DMY>
	struct _selector<512, DMY>
	{
		typedef CSHA512	type;
	};

public:
	typedef typename _selector<SHA, void>::type	type;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
