//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMD5.h
 * @brief		MD5 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndMD5_H_
#define INCG_IRIS_FndMD5_H_

//======================================================================
// include
#include "FndHash.h"
#include "../../math/hash/MathMD5.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// nbVC^[tFCXNX
class CMD5 : public IHash
{
public:
	static const int HASHSIZE = math::MD5HASHSIZE;
	typedef math::MD5CONTEXT					CONTEXT;
	typedef Digest<math::MD5DIGEST, HASHSIZE>	DIGEST;
protected:
	CONTEXT		m_Context;

public:
	// RXgN^
	CMD5(void);
	CMD5(const u8* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN>
	CMD5(const TN* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN, size_t SIZE>
	CMD5(const TN (&lpBuffer)[SIZE])			{ Encode<TN, SIZE>(lpBuffer); }

	// fXgN^
	virtual ~CMD5(void);
public:

	// 
	virtual void	Init(void);
	// NA
	virtual void	Clear(void);
	// XV
	virtual void	Update(const u8* lpBuffer, size_t uLength);
	// ŏIXV
	virtual void	Final(void);
	// nbV̏o
	virtual void	GetDigest(u8* lpBuffer)	const;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize, u8* lpHashBuffer)	const;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize, u8* lpHashBuffer)	const;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize)	const;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize)	const;
	// nbVTCY̎擾
	virtual u32		GetHashSize(void)	const	{ return HASHSIZE; }

public:
	// ReLXg̎擾
	const CONTEXT&	GetContext(void)	const	{ return m_Context; }

};

}	// end of namespace fnd
}	// end of namespace iris

#endif
