//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMD5.cpp
 * @brief		MD5 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndMD5_CPP_

//======================================================================
// include
#include "FndMD5.h"

namespace iris {
namespace fnd
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMD5::CMD5(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMD5::~CMD5(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CMD5::Init(void)
{
	math::MD5InitContext(&m_Context);
}

/**********************************************************************//**
 *
 * NA
 *
*//***********************************************************************/
void CMD5::Clear(void)
{
	math::MD5ClearContext(&m_Context);
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@
*//***********************************************************************/
void CMD5::Update(const u8* lpBuffer, size_t uLength)
{
	math::MD5Update(&m_Context, lpBuffer, uLength);
}

/**********************************************************************//**
 *
 * ŏIXV
 *
*//***********************************************************************/
void CMD5::Final(void)
{
	math::MD5Final(&m_Context);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void CMD5::GetDigest(u8* lpBuffer)	const
{
	math::MD5Output(&m_Context, lpBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpHashBuffer= nbV
*//***********************************************************************/
void CMD5::ToStringA(LPSTR  lpString, size_t uSize, u8* lpHashBuffer)	const
{
	math::MD5ToStringA(lpString, uSize, lpHashBuffer);
}
/** @ref ToStringA */
void CMD5::ToStringW(LPWSTR lpString, size_t uSize, u8* lpHashBuffer)	const
{
	math::MD5ToStringW(lpString, uSize, lpHashBuffer);
}

/**********************************************************************//**
 *
 * nbV̏o
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpBuffer	= nbV
*//***********************************************************************/
void CMD5::ToStringA(LPSTR  lpString, size_t uSize)	const
{
	_ToStringA<HASHSIZE>(lpString, uSize);
}
/** @ref ToStringA */
void CMD5::ToStringW(LPWSTR lpString, size_t uSize)	const
{
	_ToStringW<HASHSIZE>(lpString, uSize);
}

}	// end of namespace fnd
}	// end of namespace iris

#if	defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"

TEST(CFndMD5Test, Function)
{
	char comm[256] = "";

	CMD5 md5;
	md5.Encode(comm, 0);
	md5.ToStringA(comm, 256);
	ASSERT_STREQ( "d41d8cd98f00b204e9800998ecf8427e", comm );

	strcpy_s(comm, 256, "a");
	md5.Encode(comm, strlen(comm));
	md5.ToStringA(comm, 256);
	ASSERT_STREQ( "0cc175b9c0f1b6a831c399e269772661", comm );

	strcpy_s(comm, 256, "abc");
	md5.Encode(comm, strlen(comm));
	md5.ToStringA(comm, 256);
	ASSERT_STREQ( "900150983cd24fb0d6963f7d28e17f72", comm );

	strcpy_s(comm, 256, "message digest");
	md5.Encode(comm, strlen(comm));
	md5.ToStringA(comm, 256);
	ASSERT_STREQ( "f96b697d7cb7938d525a2f31aaf161d0", comm );

	strcpy_s(comm, 256, "abcdefghijklmnopqrstuvwxyz");
	md5.Encode(comm, strlen(comm));
	md5.ToStringA(comm, 256);
	ASSERT_STREQ( "c3fcd3d76192e4007dfb496cca67e13b", comm );

	strcpy_s(comm, 256, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
	md5.Encode(comm, strlen(comm));
	md5.ToStringA(comm, 256);
	ASSERT_STREQ( "d174ab98d277d9f5a5611c2c9f419d9f", comm );

	strcpy_s(comm, 256, "12345678901234567890123456789012345678901234567890123456789012345678901234567890");
	md5.Encode(comm, strlen(comm));
	md5.ToStringA(comm, 256);
	ASSERT_STREQ( "57edf4a22be3c955ac49da2e2107b67a", comm );
}

TEST(CFndMD5Test, Constructor)
{
	char comm[256] = "";
	CMD5 md5("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");	// NULL ܂ނ̂Ōʂς
	md5.ToStringA(comm, 256);
	ASSERT_STREQ( "df171d5c48a54bddab6b3829bf5a6ab3", comm );
}
#endif	// #if	defined(_IRIS_SUPPORT_GOOGLETEST)
