//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndHash.h
 * @brief		Hash C^[tFCX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndHash_H_
#define INCG_IRIS_FndHash_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"
#include "../../c++0x/cpp0x_enable_if.hpp"
#include "../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// nbVC^[tFCXNX
class IHash : public IIrisObject
{
protected:
	template<typename D_, int HASHSIZE_>
	struct Digest : public D_
	{
		bool operator == (const Digest& rhs)
		{
			for( int i=0; i < HASHSIZE_; ++i )
			{
				if( this->hash[i] != rhs.hash[i] ) return false;
			}
			return true;
		}
		bool operator != (const Digest& rhs)
		{
			for( int i=0; i < HASHSIZE_; ++i )
			{
				if( this->hash[i] == rhs.hash[i] ) return false;
			}
			return true;
		}
	};
public:
	/// RXgN^
	IHash(void)	{}
	IHash(const u8* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN>
	IHash(const TN* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN, size_t SIZE>
	IHash(const TN (&lpBuffer)[SIZE])			{ Encode<TN, SIZE>(lpBuffer); }

	/// fXgN^
	virtual ~IHash(void) {}

public:
	/// 
	virtual void	Init(void)	= 0;
	/// NA
	virtual void	Clear(void)	= 0;
	/// XV
	virtual void	Update(const u8* lpBuffer, size_t uLength)	= 0;
	/// ŏIXV
	virtual void	Final(void)	= 0;
	/// nbV̏o
	virtual void	GetDigest(u8* lpBuffer) const	= 0;
	/// nbVobt@當o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize, u8* lpHashBuffer)	const = 0;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize, u8* lpHashBuffer)	const = 0;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize) const	= 0;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize) const	= 0;
	/// nbVTCY̎擾
	virtual u32		GetHashSize(void)	const	= 0;

public:
	/// nbVobt@當o
	template<typename CHARTYPE_>
	void	ToString(CHARTYPE_* lpString, size_t uSize, u8* lpHashBuffer
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, CHAR> >::type*& =cpp0x::enabler::value) const
	{
		ToStringA(lpString, uSize, lpHashBuffer);
	}
	template<typename CHARTYPE_>
	void	ToString(CHARTYPE_* lpString, size_t uSize, u8* lpHashBuffer
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, WCHAR> >::type*& =cpp0x::enabler::value) const
	{
		ToStringW(lpString, uSize, lpHashBuffer);
	}
	/// o
	template<typename CHARTYPE_>
	void	ToString(CHARTYPE_* lpString, size_t uSize
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, CHAR> >::type*& =cpp0x::enabler::value) const
	{
		ToStringA(lpString, uSize);
	}
	template<typename CHARTYPE_>
	void	ToString(CHARTYPE_* lpString, size_t uSize
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, WCHAR> >::type*& =cpp0x::enabler::value) const
	{
		ToStringW(lpString, uSize);
	}

	/// ꊇvZ
	void	Encode(const u8* lpBuffer, size_t uLength)
	{
		Clear();
		Init();
		Update(lpBuffer, uLength);
		Final();
	}

public:
	template<typename TN>
	void	Update(const TN* lpBuffer, size_t uLength)
	{
		Update(pointer_cast<const u8*>(lpBuffer), uLength);
	}
	template<typename TN>
	void	GetDigest(const TN* lpBuffer)	const
	{
		GetDigest(pointer_cast<const u8*>(lpBuffer));
	}
	/// ꊇvZ
	template<typename TN>
	void	Encode(const TN* lpBuffer, size_t uLength)
	{
		Encode(pointer_cast<const u8*>(lpBuffer), uLength);
	}
	template<typename TN, size_t SIZE>
	void	Encode(const TN (&lpBuffer)[SIZE])
	{
		Encode(pointer_cast<const u8*>(lpBuffer), SIZE * sizeof(TN));
	}

protected:
	template<int SIZE>
	void	_ToStringA(LPSTR  lpString, size_t uSize)	const
	{
		IRIS_STATIC_ASSERT(SIZE > 0);
		u8 output[SIZE];
		GetDigest(output);
		ToStringA(lpString, uSize, output);
	}
	template<int SIZE>
	void	_ToStringW(LPWSTR lpString, size_t uSize)	const
	{
		IRIS_STATIC_ASSERT(SIZE > 0);
		u8 output[SIZE];
		GetDigest(output);
		ToStringW(lpString, uSize, output);
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
