//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndCRC32.h
 * @brief		CRC32 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndCRC32_H_
#define INCG_IRIS_FndCRC32_H_

//======================================================================
// include
#include "FndHash.h"
#include "../../math/hash/MathCRC32.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	CRC32 C^[tF[XNX
*/
class ICRC32 : public IHash
{
public:
	static const int HASHSIZE = CRC32HASHSIZE;
	typedef u32		CONTEXT;

protected:
	CONTEXT	m_Context;	//!< ReLXg

public:
	// RXgN^
	ICRC32(void);
	ICRC32(const u8* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN>
	ICRC32(const TN* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN, size_t SIZE>
	ICRC32(const TN (&lpBuffer)[SIZE])			{ Encode<TN, SIZE>(lpBuffer); }

public:
	bool	operator	== (const ICRC32& rhs)	const	{ return m_Context == rhs.m_Context; }
	bool	operator	!= (const ICRC32& rhs)	const	{ return m_Context != rhs.m_Context; }

public:

	// 
	virtual void	Init(void);
	// NA
	virtual void	Clear(void);
	// ŏIXV
	virtual void	Final(void);
	// nbV̏o
	virtual void	GetDigest(u8* lpBuffer)	const;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize, u8* lpHashBuffer)	const;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize, u8* lpHashBuffer)	const;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize)	const;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize)	const;
	// nbVTCY̎擾
	virtual u32		GetHashSize(void)	const	{ return HASHSIZE; }

public:
	// ReLXg̎擾
	const CONTEXT&	GetContext(void)	const	{ return m_Context; }
};

/**
 * @brief	CRC32 () C^[tF[XNX
*/
template<u32 FIRST=0xFFFFFFFF, u32 LAST=0>
class CCRC32L : public ICRC32
{
public:
	// RXgN^
	CCRC32L(void);
	CCRC32L(const u8* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN>
	CCRC32L(const TN* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN, size_t SIZE>
	CCRC32L(const TN (&lpBuffer)[SIZE])			{ Encode<TN, SIZE>(lpBuffer); }

public:
	// 
	virtual void	Init(void)	{ m_Context = FIRST; }
	// ŏIXV
	virtual void	Final(void)	{ m_Context ^= LAST; }

public:
	/// XV
	virtual void	Update(const u8* lpBuffer, size_t uLength)
	{
		m_Context = CRC32LUpdate(lpBuffer, uLength, m_Context, 0);
	}
};

/**
 * @brief	CRC32 (E) C^[tF[XNX
*/
template<u32 FIRST=0xFFFFFFFF, u32 LAST=0>
class CCRC32R : public ICRC32
{
public:
	// RXgN^
	CCRC32R(void);
	CCRC32R(const u8* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN>
	CCRC32R(const TN* lpBuffer, size_t uLength)	{ Encode(lpBuffer, uLength); }
	template<typename TN, size_t SIZE>
	CCRC32R(const TN (&lpBuffer)[SIZE])			{ Encode<TN, SIZE>(lpBuffer); }

public:
	// 
	virtual void	Init(void)	{ m_Context = FIRST; }
	// ŏIXV
	virtual void	Final(void)	{ m_Context ^= LAST; }

public:
	/// XV
	virtual void	Update(const u8* lpBuffer, size_t uLength)
	{
		m_Context = CRC32RUpdate(lpBuffer, uLength, m_Context, 0);
	}
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
