//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRIFF.h
 * @brief		RIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRIFF_H_
#define INCG_IRIS_FndRIFF_H_

//======================================================================
// include
#include "../io/FndIFile.h"
#include "../container/FndFileBuffer.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<typename FILE>class CRIFF;

//======================================================================
// struct
/// RIFF `N
typedef struct tagRIFF_FILE_CHUNK
{
	u4cc	uID;		//!< t@Cʎq
	s32		Size;		//!< t@CTCY
	u32		uForm;		//!< tH[^Cv
} RIFF_FILE_CHUNK, *LPRIFF_FILE_CHUNK;

/// RIFF Tu`N wb_
typedef struct tagRIFF_CHUNK_HEADER
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
} RIFF_CHUNK_HEADER, *LPRIFF_CHUNK_HEADER;

/// RIFF LIST `N
typedef struct tagRIFF_LIST_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u32		uType;		//!< Xg^Cv
} RIFF_LIST_CHUNK, *LPRIFF_LIST_CHUNK;

/// RIFF Tu`N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u8		pData[1];	//!< f[^
} RIFF_CHUNK, *LPRIFF_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF fmt `N
typedef struct tagRIFF_FMT_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	u16		Fmt;			//!< tH[}bg
	u16		Channels;		//!< `l
	u32		SamplePerSec;	//!< TvO(Hz)
	u32		BytePerSec;		//!< σf[^
	u16		BlockAlign;		//!< f[^̃ubNTCY
	u16		BitsWidth;		//!< 1Tvbit
} RIFF_FMT_CHUNK, *LPRIFF_FMT_CHUNK;

/// RIFF gfmt `N
#include "../../misc/iris_pushpack2.h"
typedef IRIS_PACKED struct tagRIFF_FMT_EX_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	u16		Fmt;			//!< tH[}bg
	u16		Channels;		//!< `l
	u32		SamplePerSec;	//!< TvO(Hz)
	u32		BytePerSec;		//!< σf[^
	u16		BlockAlign;		//!< f[^̃ubNTCY
	u16		BitsWidth;		//!< 1Tvbit
	u16		ExtSize;		//!< gTCY
} RIFF_FMT_EX_CHUNK, *LPRIFF_FMT_EX_CHUNK;
#include "../../misc/iris_poppack.h"

/// RIFF data `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_DATA_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u8		pData[1];	//!< f[^
} RIFF_DATA_CHUNK, *LPRIFF_DATA_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF cue point \
typedef struct tagRIFF_CUEPOINT
{
	s32		Identifier;		//!< 
	s32		Position;		//!< 
	u32		Chunk;			//!< 
	s32		ChunkStart;		//!< 
	s32		BlockStart;		//!< 
	s32		SampleOffset;	//!< 
} RIFF_CUEPOINT, *LPRIFF_CUEPOINT;

/// RIFF cue `N
typedef struct tagRIFF_CUE_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	s32		nCuePoint;			//!< CuePoint
	RIFF_CUEPOINT Points[1];	//!< CuePoint
} RIFF_CUE_CHUNK, *LPRIFF_CUE_CHUNK;


/// RIFF Playlist \
typedef struct tagRIFF_SEGMENT
{
	s32		Identifier;		//!< 
	s32		Length;			//!< 
	s32		Repeats;		//!< 
} RIFF_SEGMENT, *LPRIFF_SEGMENT;

/// RIFF Playlist `N
typedef struct tagRIFF_PLST_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s32		nSegment;		//!< segment
	RIFF_SEGMENT Segments;	//!< segment
} RIFF_PLST_CHUNK, *LPRIFF_PLST_CHUNK;


/// RIFF Label `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_LABL_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s32		Identifier;		//!< 
	char	Text[1];		//!< eLXg
} RIFF_LABL_CHUNK, *LPRIFF_LABL_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF note `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_NOTE_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s32		Identifier;		//!< 
	char	Text[1];		//!< eLXg
} RIFF_NOTE_CHUNK, *LPRIFF_NOTE_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF Label Text `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_LTXT_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s32		Identifier;		//!< 
	s32		SampleLength;	//!< 
	s32		Purpose;		//!< 
	s16		Country;		//!< 
	s16		Language;		//!< 
	s16		Dialect;		//!< 
	s16		CodePage;		//!< 
	char	Text[1];		//!< eLXg
} RIFF_LTXT_CHUNK, *LPRIFF_LTXT_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF Sample Loop \
typedef struct tagRIFF_SMPL_LOOP
{
	s32		Identifier;		//!< 
	s32		Type;			//!< ^Cv
	s32		Start;			//!< [vJnTv
	s32		End;			//!< [vITv
	s32		Fraction;		//!< 
	s32		PlayCount;		//!< 
} RIFF_SMPL_LOOP, *LPRIFF_SMPL_LOOP;

/// RIFF smpl `N
typedef struct tagRIFF_SMPL_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	s32		Manufacturer;		//!< 
	s32		Product;			//!< 
	s32		SamplePeriod;		//!< 
	s32		MIDIUnityNote;		//!< 
	s32		MIDIPitchFraction;	//!< 
	s32		SMPTEFormat;		//!< 
	s32		SMPTEOffset;		//!< 
	s32		SampleLoops;		//!< [v
	s32		SamplerData;		//!< [vTCY
	RIFF_SMPL_LOOP	Loops[1];	//!< [v
} RIFF_SMPL_CHUNK, *LPRIFF_SMPL_CHUNK;


/// RIFF Instruments `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_INST_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	u8		UnshiftedNote;		//!< 
	s8		FineTune;			//!< 
	s8		Gain;				//!< 
	u8		LowNote;			//!< 
	u8		HighNote;			//!< 
	u8		LowVelocity;		//!< 
	u8		HighVelocity;		//!< 
} RIFF_INST_CHUNK, *LPRIFF_INST_CHUNK;
#include "../../misc/iris_poppack.h"

/// RIFF AVIH `N
typedef struct tagRIFF_AVIH_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	u32		MicroSecPerFrame;	//!< t[ԁi܂ 0j
	u32		MaxBytesPerSec;		//!< ][g̍ől
	u32		PaddingGranularity;	//!< ̃TCY̔{ɃpfBO
	u32		Flags;				//!< ŒtO
	u32		TotalFrames;		//!< # t@C̃t[
	u32		InitialFrames;		//!< t[
	u32		Streams;			//!< Xg[
	u32		SuggestedBufferSize;//!< 
	u32		Width;				//!< rfIXg[̕
	u32		Height;				//!< rfIXg[̍
} RIFF_AVIH_CHUNK, *LPRIFF_AVIH_CHUNK;

/// RIFF stream header `N
typedef struct tagRIFF_STRH_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	u4cc	uType;				//!< ^Cv
	u4cc	uHandler;			//!< R[fbN̎ʎq
	u32		Flags;				//!< tO
	u16		Priority;			//!< vCIeB
	u16		Language;			//!< 
	u32		InitialFrames;		//!< t@Cɑ݂Xg[̍ŏ̃ubN̐
	u32		Scale;				//!< Rate / Scale == samples/second
	u32		Rate;				//!< Rate / Scale == samples/second
	u32		Start;				//!< Xg[̊Jn
	u32		Length;				//!< RateScaleŒ`Pʂł̃Xg[̃TCY
	u32		SuggestedBufferSize;//!< 
	u32		Quality;			//!< NIeB
	u32		SampleSize;			//!< Xg[̍ŏP
    IrisIRect	Frame;			//!< t[
} RIFF_STRH_CHUNK, *LPRIFF_STRH_CHUNK;



//======================================================================
// enum
// `Nʎq
typedef enum
{
	// big endian
	RIFF_ID_FILE_CHUNK	= IRIS_FOURCC_BE('R', 'I', 'F', 'F'),	//!< t@C
	RIFF_ID_LIST_CHUNK	= IRIS_FOURCC_BE('L', 'I', 'S', 'T'),	//!< Xg`N

	// audio
	RIFF_ID_FMT_CHUNK	= IRIS_FOURCC_BE('f', 'm', 't', ' '),	//!< fmt`N
	RIFF_ID_DATA_CHUNK	= IRIS_FOURCC_BE('d', 'a', 't', 'a'),	//!< data`N
	RIFF_ID_FACT_CHUNK	= IRIS_FOURCC_BE('f', 'a', 'c', 't'),	//!< fact`N
	RIFF_ID_CUE_CHUNK	= IRIS_FOURCC_BE('c', 'u', 'e', ' '),	//!< cue`N
	RIFF_ID_PLST_CHUNK	= IRIS_FOURCC_BE('p', 'l', 's', 't'),	//!< playlist`N
	RIFF_ID_LABL_CHUNK	= IRIS_FOURCC_BE('l', 'a', 'b', 'l'),	//!< x`N
	RIFF_ID_NOTE_CHUNK	= IRIS_FOURCC_BE('n', 'o', 't', 'e'),	//!< note`N
	RIFF_ID_LTXT_CHUNK	= IRIS_FOURCC_BE('l', 't', 'x', 't'),	//!< xeLXg`N
	RIFF_ID_SMPL_CHUNK	= IRIS_FOURCC_BE('s', 'm', 'p', 'l'),	//!< smpl`N
	RIFF_ID_INST_CHUNK	= IRIS_FOURCC_BE('i', 'n', 's', 't'),	//!< inst`N

	// avi
	RIFF_ID_AVIH_CHUNK	= IRIS_FOURCC_BE('a', 'v', 'i', 'h'),	//!< avih`N
	RIFF_ID_STRH_CHUNK	= IRIS_FOURCC_BE('s', 't', 'r', 'h'),	//!< strh`N
	RIFF_ID_STRF_CHUNK	= IRIS_FOURCC_BE('s', 't', 'r', 'f'),	//!< strf`N
	RIFF_ID_STRN_CHUNK	= IRIS_FOURCC_BE('s', 't', 'r', 'n'),	//!< strn`N
	RIFF_ID_INDX_CHUNK	= IRIS_FOURCC_BE('i', 'n', 'd', 'x')	//!< indx`N
} RIFF_CHUNK_ID;

//!< RIFF tH[^Cv
typedef enum
{
	RIFF_FORM_WAVE	= IRIS_FOURCC_BE('W', 'A', 'V', 'E'),	//!< WAVE
	RIFF_FORM_CDDA	= IRIS_FOURCC_BE('C', 'D', 'D', 'A'),	//!< CDDA
	RIFF_FORM_AVI	= IRIS_FOURCC_BE('A', 'V', 'I', ' ')	//!< AVI 
} RIFF_FORM_TYPE;

//======================================================================
// class
/// RIFFtH[}bgt@CNX
template<typename FILE>
class CRIFF : private INonCopyable<>
{
	typedef FILE	File;
	typedef typename fnd::CFileHandleClassType<FILE>::type	FileHandler;
protected:
	File	m_File;	//!< t@C
	u32		m_Form;	//!< tH[^Cv
public:
	//! RXgN^
	CRIFF(void) : m_Form(0)	{}
	//! fXgN^
	virtual ~CRIFF(void)	{ Close(); }
public:
	//! J
	template<typename CHARTYPE_>
	bool	Open (const CHARTYPE_* fname)
	{
		Close();

		// wb_mF
		FileHandler file;
		if( !file.Open(fname, FOPEN_READ) ) return false;
		RIFF_FILE_CHUNK header;
		if( file.Read(&header, sizeof(header)) == 0 ) return false;
		if( header.uID != RIFF_ID_FILE_CHUNK ) return false;
		file.Close();

		if( !m_File.Open(fname, FOPEN_READ) ) return false;
		m_Form = header.uForm;
		m_File.Seek(sizeof(header), FILE_SEEK_CUR);
		return true;
	}

	bool	OpenA(LPCSTR  fname)	{ return Open(fname); }
	bool	OpenW(LPCWSTR fname)	{ return Open(fname); }

	//! 
	void	Close(void)				{ m_File.Close(); }

public:
	//! LȏԂǂ
	bool	IsValid(void)		const	{ return m_File.IsOpen(); }
	//! t@CTCY̎擾
	u32		GetSize(void)		const	{ return m_File.GetSize(); }
	//! tH[^Cv̎擾
	u32		GetFormType(void)	const	{ return m_Form; }

public:
	//
	//! `Nɉ
	bool	Descend(u32 ChunkType)
	{
		if( !IsValid() ) return false;
		RIFF_CHUNK_HEADER chunk;
		while(1)
		{
			s32 seek = m_File.Tell();
			if( static_cast<u32>(seek) == m_File.GetSize() ) break;

			if( m_File.Read(&chunk, sizeof(chunk)) == 0 ) break;
			if( chunk.uID == ChunkType )
			{
				m_File.Seek(seek, FILE_SEEK_SET);
				return true;
			}
			else
			{
				m_File.Seek(chunk.Size, FILE_SEEK_CUR);
			}
		}
		return false;
	}
	//! 1i
	bool	Descend(void)
	{
		if( !IsValid() ) return false;
		RIFF_CHUNK_HEADER chunk;
		if( m_File.Read(chunk, sizeof(chunk)) == 0 ) return false;
		m_File.Seek(chunk.Size, FILE_SEEK_CUR);
		return true;
	}

	//! `N
	bool	Ascend(void)
	{
		if( !IsValid() ) return false;
		m_File.Seek(sizeof(RIFF_FILE_CHUNK), FILE_SEEK_SET);
		return true;
	}

	//! `Nǂݎ
	u32		Read(void* buf, u32 size)
	{
		if( !IsValid() ) return false;
		return m_File.Read(buf, size);
	}

	//! seek
	bool		Seek(long offset, int origin)	{ return m_File.Seek(offset, origin); }
	//! tell
	s32			Tell(void) const				{ return m_File.Tell(); }
};

/**
 * @brief	obt@WJς RIFF NX
*/
template<typename FILE>
class CRIFFBuffer : public CRIFF< CFileBuffer< typename CFileHandleClassType<FILE>::type > >
{
public:
	//! RXgN^
	CRIFFBuffer(void)	{}

public:
	//! Xg`N
	LPRIFF_LIST_CHUNK FindListChunk(LPRIFF_LIST_CHUNK start)
	{
		if( !this->IsValid() ) return nullptr;
		LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)this->m_File.ptr();
		u32 size = this->GetSize();
		u8* end  = (u8*)this->m_File.ptr() + size;
		if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

		u8* next = start == nullptr ? (u8*)(head + 1) : (u8*)start + sizeof(RIFF_LIST_CHUNK) + start->Size;
		while(next < end)
		{
			if( *(u32*)next == RIFF_ID_LIST_CHUNK )
			{
				LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)next;
				return chunk;
			}
			else
			{
				LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
				next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
			}
		}
		return nullptr;
	}
	//! LIST`Ň
	LPRIFF_LIST_CHUNK FindListChunk(u32 ListType)
	{
		if( !this->IsValid() ) return nullptr;
		LPRIFF_FILE_CHUNK head = pointer_cast<LPRIFF_FILE_CHUNK>(this->m_File.ptr());
		u32 size = this->GetSize();
		u8* end  = pointer_cast<u8*>(this->m_File.ptr()) + size;
		if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

		u8* next = (u8*)(head + 1);
		while(next < end)
		{
			if( *(u32*)next == RIFF_ID_LIST_CHUNK )
			{
				LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)next;
				if( chunk->uType == ListType )
				{
					return chunk;
				}
				else
				{
					next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
				}
			}
			else
			{
				LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
				next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
			}
		}
		return nullptr;
	}

	//! `Ň
	LPRIFF_CHUNK FindChunk(LPRIFF_CHUNK start)
	{
		if( !this->IsValid() ) return nullptr;
		LPRIFF_FILE_CHUNK head = pointer_cast<LPRIFF_FILE_CHUNK>(this->m_File.ptr());
		u32 size = this->GetSize();
		u8* end  = pointer_cast<u8*>(this->m_File.ptr()) + size;
		if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

		u8* next = start == nullptr ? pointer_cast<u8*>(head + 1) : pointer_cast<u8*>(start) + sizeof(RIFF_CHUNK) + start->Size;
		while(next < end)
		{
			if( *(u32*)next == RIFF_ID_LIST_CHUNK )
			{
				LPRIFF_LIST_CHUNK chunk = (LPRIFF_LIST_CHUNK)next;
				next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
			}
			else
			{
				LPRIFF_CHUNK chunk = (LPRIFF_CHUNK)next;
				return chunk;
			}
		}
		return nullptr;
	}

	//! `N
	LPRIFF_CHUNK FindChunk(u32 ChunkType)
	{
		if( !this->IsValid() ) return nullptr;
		LPRIFF_FILE_CHUNK head = (LPRIFF_FILE_CHUNK)this->m_File.ptr();
		u32 size = this->GetSize();
		u8* end  = pointer_cast<u8*>(this->m_File.ptr()) + size;
		if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

		u8* next = pointer_cast<u8*>(head + 1);
		while(next < end)
		{
			if( *(u32*)next == RIFF_ID_LIST_CHUNK )
			{
				LPRIFF_LIST_CHUNK chunk = pointer_cast<LPRIFF_LIST_CHUNK>(next);
				next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
			}
			else
			{
				LPRIFF_CHUNK chunk = pointer_cast<LPRIFF_CHUNK>(next);
				if( chunk->uID == ChunkType )
				{
					return chunk;
				}
				else
				{
					next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
				}
			}
		}
		return nullptr;
	}

	//! XgTu`N
	LPRIFF_CHUNK FindChunk(LPRIFF_LIST_CHUNK list, LPRIFF_CHUNK start)
	{
		if( list == nullptr ) return FindChunk(start);
		if( !this->IsValid() ) return nullptr;
		u8* end  = pointer_cast<u8*>(list) + sizeof(RIFF_LIST_CHUNK) + list->Size;
		u8* next = start == nullptr ? pointer_cast<u8*>(list) + sizeof(RIFF_LIST_CHUNK) : pointer_cast<u8*>(start) + sizeof(RIFF_CHUNK) + start->Size;
		while(next < end)
		{
			if( *pointer_cast<u32*>(next) == RIFF_ID_LIST_CHUNK )
			{
				return nullptr;
			}
			else
			{
				LPRIFF_CHUNK chunk = pointer_cast<LPRIFF_CHUNK>(next);
				return chunk;
			}
		}
		return nullptr;
	}
	//! XgTu`N
	LPRIFF_CHUNK FindChunk(LPRIFF_LIST_CHUNK list, u32 ChunkType)
	{
		if( list == nullptr ) return FindChunk(ChunkType);
		if( !this->IsValid() ) return nullptr;
		u8* end  = pointer_cast<u8*>(list) + sizeof(RIFF_LIST_CHUNK) + list->Size;
		u8* next = pointer_cast<u8*>(list) + sizeof(RIFF_LIST_CHUNK);
		while(next < end)
		{
			if( *pointer_cast<u32*>(next) == RIFF_ID_LIST_CHUNK )
			{
				return nullptr;
			}
			else
			{
				LPRIFF_CHUNK chunk = pointer_cast<LPRIFF_CHUNK>(next);
				if( chunk->uID == ChunkType )
				{
					return chunk;
				}
				else
				{
					next = next + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
				}
			}
		}
		return nullptr;
	}

	//! ̃`N擾
	LPRIFF_CHUNK_HEADER GetNextChunk(const LPRIFF_CHUNK_HEADER chunk)
	{
		if( !this->IsValid() ) return nullptr;
		LPRIFF_FILE_CHUNK head = pointer_cast<LPRIFF_FILE_CHUNK>(this->m_File.ptr());
		u32 size = this->GetSize();
		u8* end  = pointer_cast<u8*>(this->m_File.ptr()) + size;
		if( size <= sizeof(RIFF_FILE_CHUNK) ) return nullptr;

		u8* next = pointer_cast<u8*>(head + 1);
		if( chunk != nullptr )
		{
			next = pointer_cast<u8*>(chunk) + sizeof(RIFF_CHUNK_HEADER) + chunk->Size;
		}
		if( next >= end ) return nullptr;
		return pointer_cast<LPRIFF_CHUNK_HEADER>(next);
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
