//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFixedFloat.h
 * @brief		Œ菬 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFixedFloat_H_
#define INCG_IRIS_FndFixedFloat_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"
#include "../../ml/iml_math.hpp"
#include "../../ml/iml_type_select.hpp"
#include "../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// declare

//======================================================================
// class
/**
 * @brief	Œ菬_NX
 * @tparam ttTN		= i[鐮^
 * @tparam tiINT	= ̃rbg
 * @tparam tiDEC	= ̃rbg
 * @tparam tiSIGN	= ̃rbg(0 or 1)
*/
template<typename ttTN, int tiINT, int tiDEC, int tiSIGN=1>
class CFixedFloat : public IIrisObject
{
	typedef	ttTN	value_type;
	typedef CFixedFloat<ttTN, tiINT, tiDEC, tiSIGN>	_Myt;

	IRIS_STATIC_ASSERT( tiSIGN == 0 || tiSIGN == 1 );
	IRIS_STATIC_ASSERT( cpp0x::is_integral<ttTN>::value );

public:
	static const int SIGN		= tiSIGN;	//!< ̃rbg
	static const int INTSIZE	= tiINT;	//!< ̃rbg
	static const int DECSIZE	= tiDEC;	//!< ̃rbg
	static const int SHIFT		= DECSIZE;	//!< Vtgl

public:
	static const value_type ZERO		= 0;
	static const value_type ONE		= iml::static_lshift<1, DECSIZE>::value;	//!< 1
	static const value_type HALF	= iml::static_lshift<1, DECSIZE-1>::value;	//!< 0.5

private:

private:
	value_type	m_value;	//!< l

public:
	/**
	 * @name RXgN^
	 * @{
	*/
	CFixedFloat(void) : m_value(0) {}
	CFixedFloat(float f) : m_value(0) { cast_from_float(f); }
	CFixedFloat(const _Myt& rhs) : m_value(rhs.m_value) {}
	template<typename ttXTN, int tiXINT, int tiXDEC, int tiXSIGN>
	CFixedFloat(const CFixedFloat<ttXTN, tiXINT, tiXDEC, tiXSIGN>& fx) : m_value(0) { cast_from_fx(fx); }
	/**
	 * @}
	*/

public:
	//! l̎擾
	value_type		value(void)	const	{ return m_value; }

public:
	//! ^̎擾
	value_type		ToInt(void)	const	{ return integer(); }
	//! _̎擾
	float			ToFloat(void) const	{ static const float F_ONE	= (float)ONE; return m_value / F_ONE; }


public:
	/**
	 * @name	operator
	 * @{
	*/
	_Myt&			operator =	(const _Myt& rhs)			{ m_value = rhs.m_value; return *this; }
	const _Myt		operator +	(const _Myt& rhs)	const	{ _Myt ret(*this); ret += rhs; return ret; }
	_Myt&			operator +=	(const _Myt& rhs)			{ m_value += rhs.m_value; return *this; }
	const _Myt		operator -	(const _Myt& rhs)	const	{ _Myt ret(*this); ret -= rhs; return ret; }
	_Myt&			operator -=	(const _Myt& rhs)			{ m_value -= rhs.m_value; return *this; }
	const _Myt		operator *	(const _Myt& rhs)	const	{ _Myt ret(*this); ret *= rhs; return ret; }
	_Myt&			operator *=	(const _Myt& rhs)			{ m_value *= rhs.m_value; m_value >>= SHIFT; return *this; }

	bool			operator == (const _Myt& rhs)	const	{ return m_value == rhs.m_value; }
	bool			operator != (const _Myt& rhs)	const	{ return m_value != rhs.m_value; }
	bool			operator <	(const _Myt& rhs)	const	{ return m_value < rhs.m_value; }
	bool			operator <= (const _Myt& rhs)	const	{ return m_value <= rhs.m_value; }
	bool			operator >	(const _Myt& rhs)	const	{ return m_value > rhs.m_value; }
	bool			operator >= (const _Myt& rhs)	const	{ return m_value >= rhs.m_value; }


	operator int		(void)	const		{ return (int)ToInt(); }
	operator float		(void)	const		{ return ToFloat(); }

	/**
	 * @}
	*/

	/**
	 * @name	operator
	 * @{
	*/
	template<typename TT>
	_Myt&			operator =	(TT rhs)			{ m_value = rhs << SHIFT; return *this; }
	_Myt&			operator =	(float rhs)			{ cast_from_float(rhs); return *this; }
	_Myt&			operator =	(bool rhs);
	template<typename TT>
	const _Myt		operator *  (TT rhs)	const	{ _Myt ret(*this); ret *= rhs; return ret; }
	template<typename TT>
	_Myt&			operator *= (TT rhs)	const	{ m_value *= rhs; return *this; }

	template<typename TT>
	bool			operator == (TT rhs)	const	{ return m_value == rhs << SHIFT; }
	bool			operator == (float rhs)	const	{ _Myt r(rhs); return *this == r; }
	template<typename TT>
	bool			operator != (TT rhs)	const	{ return m_value != rhs << SHIFT; }
	bool			operator != (float rhs)	const	{ _Myt r(rhs); return *this == r; }

	/**
	 * @}
	*/

	/**
	 * @name	operator
	 * @{
	*/
	template<typename ttXTN, int tiXINT, int tiXDEC, int tiXSIGN>
	_Myt& operator = (const CFixedFloat<ttXTN, tiXINT, tiXDEC, tiXSIGN>& fx) { cast_from_fx(fx); return *this; }

	/**
	 * @}
	*/

private:
	// LXg
	void	cast_from_float(float f)
	{
		m_value = (value_type)( (f > 0.f) ? (f * ONE + 0.5f) : (f * ONE - 0.5f) );
	}
	template<typename ttXTN, int tiXINT, int tiXDEC, int tiXSIGN>
	void	cast_from_fx(const CFixedFloat<ttXTN, tiXINT, tiXDEC, tiXSIGN>& fx)
	{
		typedef iml::type_select< (sizeof(value_type) <= sizeof(ttXTN)), ttXTN, value_type >::type TYPE;
		TYPE v = (TYPE)(fx.value() & iml::static_mask<fx.INTSIZE + fx.DECSIZE>::value);

		m_value = (value_type)(fx.value() & iml::static_mask<fx.SIGN, fx.INTSIZE + fx.DECSIZE>::value);
		m_value |= iml::signed_rshift<fx.DECSIZE - DECSIZE>::shift<TYPE>( v ) & iml::static_mask<INTSIZE + DECSIZE>::value;
	}

private:
	// 
	value_type		sign(void)	const		{ return (m_value >> (INTSIZE+DECSIZE)) & iml::static_mask<SIGN>::value; }
	void			sign(value_type s)		{ m_value &= iml::static_mask<SIGN, INTSIZE+DECSIZE>::value; m_value |= (i&iml::static_mask<SIGN>::value) << (INTSIZE+DECSIZE); }

	// 
	value_type		integer(void)	const	{ return (m_value >> DECSIZE) & iml::static_mask<INTSIZE>::value; }
	void			integer(value_type i)	{ m_value &= iml::static_mask<INTSIZE, DECSIZE>::value; m_value |= (i&iml::static_mask<INTSIZE>::value) << DECSIZE; }

	// 
	value_type		decimal(void)	const	{ return m_value & iml::static_mask<DECSIZE>::value; }
	void			decimal(value_type d)	{ m_value &= iml::static_mask<DECSIZE>::value; m_value |= d&iml::static_mask<DECSIZE>::value; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
