//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndChunk.h
 * @brief		FndChunk t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndChunk_H_
#define INCG_IRIS_FndChunk_H_

//======================================================================
// include
#include "../io/FndFile.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @biref	`NǂݎNX
*/
class CChunk : public IIrisObject
{
public:
	/// RXgN^
	CChunk(void)	{}
	/// fXgN^
	~CChunk(void)	{}

public:
	/**
	 * @brief	`Nwb_[ǂݎ
	 * @tparam	CFILE		= t@CNX
	 * @tparam	CHUNKHEAD	= `Nwb_[
	*/
	template<class CFILE, typename CHUNKHEAD>
	static bool	ReadHeader(CFILE* file, CHUNKHEAD* chunk)
	{
		s32 seek = file->Tell();
		if( file->Read(chunk, sizeof(CHUNKHEAD)) == 0 ) return false;
		file->Seek(seek, fnd::FILE_SEEK_SET);
		return true;
	}

	/**
	 * @brief	`Nwb_[ǂݎ
	 * @tparam	CFILE		= t@CNX
	 * @tparam	CHUNKHEAD	= `Nwb_[
	*/
	template<class CFILE, typename CHUNKHEAD>
	static bool	ReadNextHeader(CFILE* file, CHUNKHEAD* chunk)
	{
		file->Seek(sizeof(CHUNKHEAD)+chunk->Size, fnd::FILE_SEEK_CUR);
		return ReadHeader(file, chunk);
	}

	/**
	 * @brief	`Nwb_[ǂݎ
	 * @tparam	CFILE		= t@CNX
	 * @tparam	CHUNKHEAD	= `Nwb_[
	*/
	template<class CFILE, typename CHUNK>
	static bool	ReadChunk(CFILE* file, CHUNK* chunk)
	{
		if( file->Read(chunk, sizeof(CHUNK)) == 0 ) return false;
		return true;
	}


};

}	// end of namespace fnd
}	// end of namespace iris

#endif
