//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndCDDAText.h
 * @brief		FndCDDAText t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndCDDAText_H_
#define INCG_IRIS_FndCDDAText_H_

//======================================================================
// include
#include "../container/FndString.h"
#include "../container/FndMap.h"
#include "../io/FndDeviceIO.h"
#include "../format/FndCDDA.h"
#include "../../iris_xchar.hpp"
#include "../../iris_debug.h"

#if defined(_IRIS_SUPPORT_WDK)

namespace iris {
namespace fnd
{

//======================================================================
// enum
// pack type
typedef enum
{
	ALBUM_NAME	= 0,	//!< Ao
	PERFORMER,			//!< t
	SONGWRITER,			//!< 쎌
	COMPOSER,			//!< Ȏ
	ARRANGER,			//!< ҋȎ
	MESSAGE,			//!< bZ[W
	DISK_ID,			//!< fBXNID
	GENRE,				//!< W
	TOC_INFO,			//!< TOC
	TOC_INFO2,			//!< TOC 2
	RESERVED1,			//!< \
	RESERVED2,			//!< \
	RESERVED3,			//!< \
	RESERVED4,			//!< \
	UPC_EAN,			//!< UPC EAN
	SIZE_INFO,			//!< TCY
	PACKTYPE_NUM		//!< pack type 
} PACKTYPE;

//======================================================================
// declare
template<typename CHARTYPE_, typename Allocator_>class CTCDDAText;

//======================================================================
// class
template<typename Allocator_ = CNewAllocator< CHAR> >class CCDDATextA : public CTCDDAText< CHAR, Allocator_> {};
template<typename Allocator_ = CNewAllocator<WCHAR> >class CCDDATextW : public CTCDDAText<WCHAR, Allocator_> {};
template<typename Allocator_ = CNewAllocator<TCHAR> >class CCDDAText  : public CTCDDAText<TCHAR, Allocator_> {};

//======================================================================
// class
/**
 * @brief	Table of Contents ǂݎNX
*/
template<typename CHARTYPE_, typename Allocator_ = CNewAllocator<CHARTYPE_> >
class CTCDDAText : public IIrisObject
{
	typedef int_least_type<MINIMUM_CDROM_READ_TOC_EX_SIZE*8>::UInt	size_type_raw;
	typedef endian_base<size_type_raw>::type	size_type;
	typedef typename CBuffer<u8, Allocator_>	_Mybuffer;
	typedef typename CTStringBuffer<CHARTYPE_, Allocator_>	_Mystring;
	typedef typename CMap<int, _Mystring>			_Mymap;

protected:
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;
protected:
	_Mymap		m_Text[PACKTYPE_NUM];	//!< eLXgobt@

public:
	/// RXgN^
	CTCDDAText(void) {}

public:
	/// J
	bool	Open(IDeviceIO* drive, int nRetry=4)
	{
		if( drive == nullptr ) return false;
		//if( !drive->IsValid() ) return false;
		//if( !drive->IsReady() ) return false;

		CDROM_READ_TOC_EX tocex = {0};
		tocex.Format = CDROM_READ_TOC_EX_FORMAT_CDTEXT;

		size_type size_info;
		DWORD dwRead = 0;
		for( int retry=0; retry < nRetry; ++retry )
		{
			if( drive->IoControl(IOCTL_CDROM_READ_TOC_EX, &tocex, sizeof(tocex), &size_info, sizeof(size_info), &dwRead) )
				break;
		}
		if( dwRead == 0 ) return false;

		size_type_raw size = size_info + sizeof(size_info);
		if( size & 1 ) ++size;

		_Mybuffer buffer;
		if( !buffer.alloc(size) ) return false;

		CDROM_TOC_CD_TEXT_DATA* ptd = pointer_cast<CDROM_TOC_CD_TEXT_DATA*>(buffer.ptr());
		dwRead = 0;
		for( int retry=0; retry < nRetry; ++retry )
		{
			if( drive->IoControl(IOCTL_CDROM_READ_TOC_EX, &tocex, sizeof(tocex), ptd, size, &dwRead) )
				break;
		}
		if( dwRead == 0 ) return false;

		CDROM_TOC_CD_TEXT_DATA_BLOCK* pDescriptors = ptd->Descriptors;
		u32 nBlocks = (dwRead - sizeof(CDROM_TOC_CD_TEXT_DATA))/sizeof(CDROM_TOC_CD_TEXT_DATA_BLOCK);

		_Mystring last;	// Jz
		last.preallocate(12);
		bool bNext = true;
		for( u32 i=0; i < nBlocks; ++i, ++pDescriptors )
		{
			u8 packType = pDescriptors->PackType - 0x80;
			if( packType >= PACKTYPE_NUM ) continue;

			_Mychar resource[6][12] = {0};	// \[X
			int resnum = 0;
			bNext = true;
			if( pDescriptors->Unicode )
			{
				for( int i=0, n=0; i < 6; ++i )
				{
					WCHAR c = pDescriptors->WText[i];
					if( c == L'\0' )
					{
						if( resource[resnum][0] == 0 || i == 5 )
						{
							bNext = false;
							break;
						}
						++resnum;
						n = 0;
					}
					else
					{
						n += wctoxc(resource[resnum]+n, 12, c);
					}
				}
			}
			else
			{
				for( int i=0, n=0; i < 12; )
				{
					UCHAR c = pDescriptors->Text[i];
					if( c == '\0' )
					{
						if( resource[resnum][0] == 0 || i == 11 )
						{
							bNext = false;
							break;
						}
						++resnum;
						n = 0;
					}
					else
					{
						i += mbtoxc(resource[resnum]+n, pointer_cast<LPCSTR>(pDescriptors->Text + i));
						++n;
					}
				}
			}
			++resnum;

			// obt@̍쐬
			int track = pDescriptors->TrackNumber;

			_Mymap::iterator it = m_Text[packType].find(track);
			if( it == m_Text[packType].end() )
			{
				it = m_Text[packType].insert(_Mymap::pair(track, _Mystring()));
				it->second.preallocate(32);
			}
			_Mystring& text = it->second;

			// ʒu0̏ꍇ́Â܂ܑ
			if( pDescriptors->CharacterPosition == 0 )
			{
				text = resource[0];
			}
			else if( pDescriptors->CharacterPosition <= 0xf )
			{
				// ʒu15菬ꍇ́AJz
				if( pDescriptors->CharacterPosition < 0xf )
				{
					text += last;
					text += resource[0];
				}
				else
				{
					text += resource[0];
				}
			}
			last.empty();	// JzNA

			if( resnum > 1 )
			{
				int tail = resnum-1;
				// ŌȊOǉ
				for( int i=1; i < tail; ++i ) text += resource[i];
				if( bNext )	last = resource[tail];
				else		text += resource[tail];
			}
		}
		return true;
	}

public:
	/**
	 * @brief	eLXg擾
	 * @param [in]	type		= ^Cv
	 * @param [in]	track		= gbNԍ
	 * @param [out]	lpszString	= o̓obt@
	 * @param [in]	length		= o̓obt@
	 * @return	
	*/
	template<typename CHARTYPE_>
	bool	ToString(int type, int track, CHARTYPE_* lpszString, u32 length)
	{
		if( lpszString == nullptr ) return false;
		if( length == 0 ) return false;
		if( type < 0 || type >= PACKTYPE_NUM ) return false;

		_Mymap::iterator it = m_Text[type].find(track);

		if( it == m_Text[type].end() ) return false;
		xcscpy_s(lpszString, length, it->second);
		return true;
	}

};

}	// end of namespace fnd
}	// end of namespace iris

#endif

#endif
