//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndCDDA.h
 * @brief		RIFF CDDA tH[}bg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndCDDA_H_
#define INCG_IRIS_FndCDDA_H_

//======================================================================
// include
#include "FndRIFF.h"

#if defined(_IRIS_SUPPORT_WDK)

EXTERN_C_BEGIN
#include "ntddcdrm.h"
EXTERN_C_END

#endif

namespace iris {
namespace fnd
{

//======================================================================
// define
#ifndef MAXIMUM_NUMBER_TRACKS
#  define MAXIMUM_NUMBER_TRACKS 100
#endif

#ifndef CD_RAW_READ_C2_SIZE
#  define CD_RAW_READ_C2_SIZE					(     296   )
#endif
#ifndef CD_RAW_READ_SUBCODE_SIZE
#  define CD_RAW_READ_SUBCODE_SIZE				(         96)
#endif
#ifndef CD_RAW_SECTOR_WITH_C2_SIZE
#  define CD_RAW_SECTOR_WITH_C2_SIZE             (2352+296   )
#endif
#ifndef CD_RAW_SECTOR_WITH_SUBCODE_SIZE
#  define CD_RAW_SECTOR_WITH_SUBCODE_SIZE        (2352    +96)
#endif
#ifndef CD_RAW_SECTOR_WITH_C2_AND_SUBCODE_SIZE
#  define CD_RAW_SECTOR_WITH_C2_AND_SUBCODE_SIZE (2352+296+96)
#endif

#ifndef CD_RAW_SECTOR_SIZE
#  define CD_RAW_SECTOR_SIZE	2352	//!< 1ZN^̃f[^oCgTCY
#endif
#ifndef CD_BLOCKS_PER_SECOND
#  define CD_BLOCKS_PER_SECOND	75		//!< 1bԂɓǂݏoZN^
#endif

//======================================================================
// function
/// MSFԂZN^ԍZo
STATICINLINE u32	MSF2FAD(UCHAR* msf) { return (((msf[0])*(CD_BLOCKS_PER_SECOND*60))+((msf[1])*CD_BLOCKS_PER_SECOND)+(msf[2])); }

//======================================================================
// struct
/// CDDA fmt `N
typedef struct tagCDDA_FMT_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
    u16		FileVersion;	//!< cdat@Co[W
	u16		NumberOfTrack;	//!< gbNԍ
	u32		SerialNumber;	//!< CD̃VAԍ
	u32		StartHsg;		//!< JnZN^ԍ
	u32		LengthHsg;		//!< ZN^
	u32		StartRedBook;	//!< gbN̊JnʒuibhubNj
	u32		LengthRedBook;	//!< gbN̒    ibhubNj
} CDDA_FMT_CHUNK, *LPCDDA_FMT_CHUNK;

//! gbN
typedef struct tagCDDA_TRACKINFO
{
	u32	StartFAD;	//!< JnZN^ԍ
	u32	EndFAD;		//!< IZN^ԍ
	u8	Control;	//!< gbN̑
	u8	Addr;		//!< Q Tu`l
	u8	Session;	//!< ZbVԍ
	u8	Reserved;	//!< \
} CDDA_TRACKINFO, *LPCDDA_TRACKINFO;

//! TOC
typedef struct tagCDDA_TOCINFO
{
	u8				FirstTrack;		//!< JngbN
	u8				LastTrack;		//!< IgbN
	CDDA_TRACKINFO	TrackInfo[MAXIMUM_NUMBER_TRACKS];
} CDDA_TOCINFO, *LPCDDA_TOCINFO;

//! ZbV
typedef struct tagCDDA_SESSION
{
	u32	EndFAD;		//!< ŏIZN^ԍ
	u8	Count;		//!< ZbV
	u8	StartTrack[MAXIMUM_NUMBER_TRACKS-1];	//!< ZbV̊JngbNԍ
	u32	StartFAD[MAXIMUM_NUMBER_TRACKS-1];		//!< ZbV̊JnZN^ԍ
} CDDA_SESSION, *LPCDDA_SESSION;

//======================================================================
// class
/**
 * @brief	CDDA t@CNX
*/
template<typename FILE>
class CCDDAFile : public IIrisObject
{
protected:
	CDDA_FMT_CHUNK	m_Format;
public:
	/**
	 * @brief	RXgN^
	*/
	CCDDAFile(void) {}

public:
	/**
	 * @brief J
	 * @param [in]	fname	= t@C
	 * @return	
	*/
	template<typename CHARTYPE_>
	bool	Open(const CHARTYPE_* fname)
	{
		CRIFF<FILE> riff;
		if( !riff.Open(fname) ) return false;
		if( riff.GetFormType() != RIFF_FORM_CDDA ) return false;

		if( !riff.Descend(RIFF_ID_FMT_CHUNK) ) return false;
		if( riff.Read(&m_Format, sizeof(CDDA_FMT_CHUNK)) == 0 ) return false;
		if( m_Format.Size != (sizeof(CDDA_FMT_CHUNK) - sizeof(RIFF_CHUNK_HEADER)) ) return false;
		return true;
	}

public:
	operator const CDDA_FMT_CHUNK& (void)	const	{ return m_Format; }
	const CDDA_FMT_CHUNK* operator -> (void) const	{ return &m_Format; }
public:
	/**
	 * @brief	tH[}bg̎擾
	*/
	const CDDA_FMT_CHUNK&	GetFormat(void)	{ return m_Format; }

	/**
	 * @breif	f[^TCY̎擾
	*/
	u32	GetSize(void)	const	{ return m_Format.LengthHsg * CD_RAW_SECTOR_SIZE; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
