//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndQuickSort.h
 * @brief		NCbN\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndQuickSort_H_
#define INCG_IRIS_FndQuickSort_H_

//======================================================================
// include
#include "../FndOperators.h"
#include "../../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	NCbN\[g
 * @note	ňvZ	O(n2)
 *			ŗǌvZ	O(n log n)
 *			όvZ	O(n log n)
 * @note	s\[g
*/
class CQuickSort : public IIrisObject
{
public:
	/**
	 * @brief NCbN\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

public:
	/**
	 * @brief NCbN\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= 擪index
	 * @param [in]	end		= I[index
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		typename Func::append<CEqualOp>::type	func2;
		Sort(elem, begin, end, func, func2);
	}

	/**
	 * @brief NCbN\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= 擪index
	 * @param [in]	end		= I[index
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func1, typename Func2>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func1& func1, const Func2& func2)
	{
		Sort<typename cpp0x::array_traits<TN>::element>(elem, begin, end, func1, func2);
	}
	template<typename ELEM, typename TN, typename Func1, typename Func2>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func1& func1, const Func2& func2)
	{
		s32 num = end - begin;
		if( num <= 1 ) return;
		int l=begin, r=end-1;
		{
#if 0
			ELEM pbt = elem[begin+(num>>1)];	// ^񒆂ɂls{bgɂ
#else
			// 3TvO̒l
			ELEM a =  elem[begin+(num>>2)];
			ELEM b =  elem[begin+(num>>1)];
			ELEM c =  elem[begin+((num*3)>>2)];
			ELEM pbt = a > b ? (a < c ? a : c) : (b < c ? b : c);
#endif

			while(1)
			{
				for( ; l < end; ++l )
					if( !func1(elem[l], pbt) ) break;
				for( ; r > begin; --r )
					if(  func2(elem[r], pbt) ) break;
				if( l >= r ) break;

				swap(elem[l++], elem[r--]);
			}
		}
		s32 half = l - begin;
		num -= half;
		Sort(elem, begin,   l, func1, func2);
		Sort(elem,     l, end, func1, func2);
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
