//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMergeSort.h
 * @brief		}[W\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndMergeSort_H_
#define INCG_IRIS_FndMergeSort_H_

//======================================================================
// include
#include "FndInsertSort.h"
#include "../../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	}[W\[g
 * @note	ňvZ	(n log n)
 *			ŗǌvZ	(n log n)
 *			όvZ	(n log n)
 * @note	\[g
*/
class CMergeSort : public IIrisObject
{
	static const s32 MINIMUM_ELEMENT		= 32;	//!< ŏvf
public:
	/**
	 * @brief }[W\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

public:
	/**
	 * @brief }[W\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= 擪index
	 * @param [in]	end		= I[index
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		Sort<cpp0x::array_traits<TN>::element>(elem, begin, end, func);
	}
	template<typename ELEM, typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		s32 num = end - begin;
		if( num <= 1 ) return;
		s32 half	= num>>1;
		Sort<ELEM>(elem, begin, end, func, begin + half);
	}
	template<typename ELEM, typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func, s32 center)
	{
		s32 num = end - begin;
		if( num <= 1 ) return;
#if 1
		if( num < MINIMUM_ELEMENT )
		{
			CInsertSort::Sort<ELEM>(elem, begin, end, func);
			return;
		}
#endif
		s32 half2 = end - center;
		s32 half1 = num - half2;

		// \[g
		Sort(elem, begin , center, func);
		Sort(elem, center, end   , func);

		// }[W
		while( 1 )
		{
			if( func(elem[begin], elem[center]) )
			{
				++begin;
				--half1;
				if( half1 == 0 ) break;
			}
			else
			{
				ELEM tmp = elem[center];
				for( s32 i=begin; i < center; ++i ) 
					elem[i+1] = elem[i];
				elem[begin] = tmp;
				++center;
				++begin;
				--half2;
				if( half2 == 0 ) break;
			}
		}
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
