//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndInsertSort.h
 * @brief		}\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndInsertSort_H_
#define INCG_IRIS_FndInsertSort_H_

//======================================================================
// include
#include "../FndOperators.h"
#include "../../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	}\[g
 * @note	ňvZ	O(n2)
 *			ŗǌvZ	O(n)
 *			όvZ	O(n2)
 * @note	rIuWFNgɓ܂ނƈ\[gɂȂ
*/
class CInsertSort : public IIrisObject
{
public:
	/**
	 * @brief }\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐(<= or >= Ȃ\[gA< or > ̓Xebv邵s)
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

public:
	/**
	 * @brief }\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= \[gJnCfbNX
	 * @param [in]	end		= \[gI[CfbNX
	 * @param [in]	func	= r֐(<= or >= Ȃ\[gA< or > ̓Xebv邵s)
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		Sort<cpp0x::array_traits<TN>::element>(elem, begin, end, func);
	}
	template<typename ELEM, typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		for( s32 i=begin+1, j; i < end; ++i )
		{
			ELEM tmp = elem[i];
			for( j=i; j > begin && !func(elem[j-1], tmp); --j )
			{
				elem[j] = elem[j-1];
			}
			elem[j]		= tmp;
		}
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
