//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndCombSort.h
 * @brief		R\[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndCombSort_H_
#define INCG_IRIS_FndCombSort_H_

//======================================================================
// include
#include "../FndOperators.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	R\[g
 * @note	ňvZ	O(n log n)
 *			ŗǌvZ	O(n log n)
 *			όvZ	O(n log n)
 * @note	s\[g
*/
class CCombSort : public IIrisObject
{
public:
	/**
	 * @brief R\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	num		= \[gz̗vf
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 num, const Func& func)
	{
		Sort(elem, 0, num, func);
	}

public:
	/**
	 * @brief R\[g
	 * @param [io]	elem	= \[gΏ۔z
	 * @param [in]	begin	= \[gJnCfbNX
	 * @param [in]	end		= \[gI[CfbNX
	 * @param [in]	func	= r֐
	*/
	template<typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		Sort<cpp0x::array_traits<TN>::element>(elem, begin, end, func);
	}
	template<typename ELEM, typename TN, typename Func>
	static void	Sort(TN& elem, s32 begin, s32 end, const Func& func)
	{
		s32 num = end - begin;
		s32 h = num * 10 / 13;
		while(h)
		{
			int swaps = 0;
			for( s32 i=0; i + h < num; ++i )
			{
				s32 j=i+begin;
				if( func(elem[j+h], elem[j]) )
				{
					swap(elem[j], elem[j+h]);
					++swaps;
				}
			}
			if( h == 1 )
			{
				if( swaps == 0 ) break;
			}
			else
			{
				h = h * 10 / 13;
#if 1
				// comb sort 11
				if( h == 9 || h == 10 ) h = 11;
#endif
			}
		}
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
