//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndString.h
 * @brief		FndString t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndString_H_
#define INCG_IRIS_FndString_H_

//======================================================================
// include
#include "FndBuffer.h"
#include "../../iris_xchar.hpp"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<typename CHARTYPE_, typename Allocator_ = CNewAllocator<CHARTYPE_> >class CTStringBuffer;

//======================================================================
// typedef
typedef CTStringBuffer<CHAR>	CStringA;
typedef CTStringBuffer<WCHAR>	CStringW;
typedef CTStringBuffer<TCHAR>	CString;

//======================================================================
// class
template<typename Allocator_ = CNewAllocator< CHAR> >class CStringBufferA : public CTStringBuffer< CHAR, Allocator_> {};
template<typename Allocator_ = CNewAllocator<WCHAR> >class CStringBufferW : public CTStringBuffer<WCHAR, Allocator_> {};
template<typename Allocator_ = CNewAllocator<TCHAR> >class CStringBuffer  : public CTStringBuffer<TCHAR, Allocator_> {};

/**
 * @brief	NX
*/
template<typename CHARTYPE_, typename Allocator_>
class CTStringBuffer : protected CBuffer<CHARTYPE_, Allocator_>
{
	typedef CBuffer<CHARTYPE_, Allocator_>			_Mybase;
	typedef CTStringBuffer<CHARTYPE_, Allocator_>	_Myt;
protected:
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;
public:

	/**
	 * @brief	RXgN^
	*/
	CTStringBuffer(void){}

	/**
	 * @brief	RXgN^
	 * @param [in]	pString	= 
	*/
	template<size_t SIZE>
	CTStringBuffer(_Mychar (&pString)[SIZE])
	{
		copy(pString);
	}

	/**
	 * @brief	RXgN^
	 * @param [in]	pString	= 
	*/
	CTStringBuffer(_Mylpcstr pString)
	{
		copy(pString);
	}


	/**
	 * @brief	Rs[RXgN^
	*/
	CTStringBuffer(const _Myt& obj)
	{
		copy(obj);
	}

public:
	/**
	 * @brief	񒷎擾(NUL)
	*/
	size_t		length(void) const
	{
		if( m_pBuffer == nullptr ) return 0;
		return xcslen(m_pBuffer);
	}

	/**
	 * @brief	obt@̎擾
	*/
	_Mylpcstr	data(void) const	{ return ptr(); }

	/**
	 * @brief	obt@̎Om
	*/
	void		preallocate(size_t length)
	{
		realloc(length+1);
		fill(0);
	}

	/**
	 * @brief	󕶎ɂ
	*/
	void		empty(void)
	{
		fill(0);
	}

	/**
	 * @brief	󕶎񂩂ǂ
	*/
	bool		is_empty(void)
	{
		return length() == 0;
	}

	/**
	 * @brief	obt@̉
	*/
	void		release(void)
	{
		dealloc();
	}

public:
	/**
	 * @brief	operator
	 * @{
	*/
	_Mychar			operator [] (int idx)			{ IRIS_ASSERT(idx < size() ); return *(ptr() + idx); }
	template<size_t SIZE>
	const _Myt&		operator = (const _Mychar (&pString)[SIZE])	{ copy(pString); return *this; }
	const _Myt&		operator = (_Mylpcstr pString)	{ copy(pString); return *this; }
	const _Myt&		operator = (const _Myt& obj)	{ copy(obj); return *this; }
	const _Myt&		operator += (_Mylpcstr pString)	{ add(pString); return *this; }
	const _Myt&		operator += (const _Myt& obj)	{ add(obj); return *this; }

	_Myt			operator + (_Mylpcstr pString)	{ _Myt r(*this); r += pString; return r; }
	_Myt			operator + (const _Myt& obj)	{ _Myt r(*this); r += obj; return r; }

	bool			operator == (_Mylpcstr pString)	{ return comp(pString); }
	bool			operator == (const _Myt& obj)	{ return comp(obj); }
	bool			operator != (_Mylpcstr pString)	{ return !comp(pString); }
	bool			operator != (const _Myt& obj)	{ return !comp(obj); }

	operator		_Mylpcstr	(void)	const	{ return ptr(); }
	/**
	 * @}
	*/

public:
	/**
	 * @brief	obt@AhX̎擾
	 * @{
	*/
	_Mylpstr	ptr(void)		{ return _Mybase::ptr(); }
	_Mylpcstr	ptr(void) const	{ return _Mybase::ptr(); }
	/**
	 * @}
	*/

private:
	void	copy(_Mylpcstr pString)
	{
		if( pString == nullptr )
		{
			dealloc();
			return;
		}
		size_t len = xcslen(pString);
		if( len+1 >= size() )
		{
			// obt@蒼
			alloc(len+1);
		}
		xcscpy_s(ptr(), len+1, pString);
	}

	void	copy(const _Myt& obj)
	{
		copy(obj.data());
	}

	void	add(_Mylpcstr pString)
	{
		if( pString == nullptr ) return;
		size_t src_len = xcslen(pString);
		if( src_len == 0 ) return;
		if( m_pBuffer == nullptr )
		{
			copy(pString);
			return;
		}

		size_t len = length() + src_len + 1;
		if( len >= size() )
		{
			_Myt temp;
			swap(temp);	// e|Ɉړ

			alloc(len);

			xcscpy_s(ptr(), len, temp.data());
		}
		xcscat_s(ptr(), len, pString);
	}

	void	add(const _Myt& obj)
	{
		add(obj.data());
	}

	bool	comp(_Mylpcstr pString)
	{
		if( pString == nullptr )
		{
			if( ptr() == nullptr ) return true;
			return false;
		}
		return xcscmp(ptr(), pString) == 0;
	}

	void	comp(const _Myt& obj)
	{
		add(obj.data());
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
