//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndScopedLock.h
 * @brief		XR[vtbNNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndScopedLock_H_
#define INCG_IRIS_FndScopedLock_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	XR[vtbNNX
 * @tparam	OBJECT	= bNNX^
*/
template<typename OBJECT>
class CSingleLock : private INonCopyable<>
{
	typedef CSingleLock<OBJECT>	_Myt;
public:
	typedef OBJECT		value_type;
	typedef OBJECT		*value_ptr;
	typedef OBJECT		&value_ref;
private:
	value_ref	m_object;	//!< ~[ebNX
	bool		m_lock;		//!< lock
public:
	/// RXgN^
	CSingleLock(value_ref object)
		: m_object(object), m_lock(false)
	{
		lock();
	}
	CSingleLock(value_ref object, u32 uTimeout)
		: m_object(object), m_lock(false)
	{
		lock(uTimeout);
	}
	/// fXgN^
	~CSingleLock(void)
	{
		unlock();
	}
public:
	/// bN
	void	lock(void)
	{
		if( !m_lock )
		{
			m_object.Lock();
			m_lock = true;
		}
	}
	/// bN
	void	lock(u32 uTimeout)
	{
		if( !m_lock )
		{
			m_object.Lock(uTimeout);
			m_lock = true;
		}
	}
	/// bN
	void	unlock(void)
	{
		if( m_lock )
		{
			m_object.Unlock();
			m_lock = false;
		}
	}
	/**
	 * @brief	bNĂ邩ǂ
	 * @return	^Ul
	*/
	bool	is_lock(void) const { return m_lock; }

public:
	value_ref	get(void)	{ return m_object; }

public:
	// ݊̂
	/// bN
	inline void	Lock(void)		{ lock(); }
	/// bN
	inline void	Unlock(void)	{ unlock(); }

private:
	const _Myt&	operator = (const _Myt& obj);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
