//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndObserver.h
 * @brief		Observerx[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSubject_H_
#define INCG_IRIS_FndSubject_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<class Observer_>class CObserverSubject;
template<class Observer_>class CObserver;

//======================================================================
// class

//======================================================================
// observer
/**
 * @brief	ĎNX
 * @tparam	Observer_	= ĎNX
*/
template<class Observer_>
class CObserverSubject : private INonCopyable<>
{
	typedef CObserverSubject<Observer_>	_Myt;
	typedef CObserver<Observer_>		_MyObserver;
public:
	typedef Observer_	value_type;
	typedef Observer_	&value_ref;	//!< ĎIuWFNgQƌ^
	typedef Observer_	*value_ptr;	//!< ĎIuWFNg|C^[
protected:
	value_ptr	m_pObservers;	//!< ĎIuWFNgXg
public:
	/// RXgN^
	CObserverSubject(void) : m_pObservers(nullptr)	{}
public:
	/// fXgN^
	virtual ~CObserverSubject(void)
	{
		_MyObserver* curr = static_cast<_MyObserver*>(m_pObservers);
		while(curr != nullptr)
		{
			OnDetach(static_cast<value_ptr>(curr));

			curr->m_pSubject = nullptr;
			curr = static_cast<_MyObserver*>(curr->m_pNext);
			curr->m_pNext = nullptr;
		}
		m_pObservers = nullptr;
	}
public:
	/// Observer ̒ǉ
	void	AttachObserver(value_ptr observer)
	{
		if( observer == nullptr ) return;
		_MyObserver* obsrv = static_cast<_MyObserver*>(observer);
		_Myt* old = obsrv->m_pSubject;
		if( old == this ) return;
		if( old != nullptr ) old->DetachObserver(obsrv);
		obsrv->m_pSubject = this;
		obsrv->m_pNext = m_pObservers;
		m_pObservers = observer;
		OnAttach(observer);
	}

	/// Observer ̑}
	bool	InsertObserver(value_ptr pos, value_ptr observer)
	{
		if( observer == nullptr ) return false;
		_MyObserver* obsrv = static_cast<_MyObserver*>(observer);
		_Myt* old = obsrv->m_pSubject;
		if( old == this ) return true;
		DetachObserver(obsrv);
		obsrv->m_pSubject = this;
		value_ptr curr = m_pObservers;
		_MyObserver* prev = nullptr;
		while( curr != pos || curr != nullptr )
		{
			prev = static_cast<_MyObserver*>(curr);
			curr = static_cast<_MyObserver*>(curr)->m_pNext;
		}
		if( curr != pos ) return false;	// s
		if( prev == nullptr )
		{
			obsrv->m_pNext = m_pObservers;
			m_pObservers = observer;
		}
		else
		{
			prev->m_pNext = observer;
			obsrv->m_pNext = curr;
		}
		OnAttach(observer);
		return true;
	}

	/// Observer ̍폜
	void	DetachObserver(_MyObserver* observer)
	{
		if( observer == nullptr ) return;
		_MyObserver* prev = nullptr;
		_MyObserver* curr = static_cast<_MyObserver*>(m_pObservers);
		while( curr != nullptr )
		{
			if( curr == observer )
			{
				OnDetach(static_cast<value_ptr>(observer));

				if( prev != nullptr )
					prev->m_pNext = observer->m_pNext;
				else
					m_pObservers = observer->m_pNext;
				observer->m_pSubject = nullptr;
				observer->m_pNext = nullptr;
				return;
			}
			prev = curr;
			curr = static_cast<_MyObserver*>(curr->m_pNext);
		}
	}

	/// Observer ̑S폜
	void	DetachObserverAll(void)
	{
		while(m_pObservers != nullptr) { DetachObserver(static_cast<_MyObserver*>(m_pObservers)); }
	}

public:
	/// Ď҂ǂ
	bool	IsObserved(value_ptr observer) const
	{
		value_ptr curr = m_pObservers;
		while(curr != nullptr)
		{
			if( curr == observer ) return true;
			curr = curr->GetNext();
		}
		return false;
	}
public:
	value_ptr		GetObservers(void)	{ return m_pObservers; }	//!< Subject ̎擾
	//! Subject ̌擾
	s32				GetObserverNum(void)	const
	{
		s32 cnt=0;
		value_ptr curr = m_pObservers;
		while(curr != nullptr)
		{
			++cnt;
			curr = curr->GetNext();
		}
		return cnt;
	}

protected:
	virtual	void	OnAttach(value_ptr /*observer*/) {}
	virtual	void	OnDetach(value_ptr /*observer*/) {}
};

/**
 * @brief	ĎNX
 * @tparam	Observer_	= ĎNX(CRTP)
*/
template<class Observer_>
class CObserver : private INonCopyable<>
{
	friend	class CObserverSubject<Observer_>;
	typedef CObserver<Observer_>		_Myt;
	typedef CObserverSubject<Observer_>	_MySubject;
	typedef Observer_					_MyObserver;
private:
	_MySubject*		m_pSubject;	//!< ĎIuWFNg
	_MyObserver*	m_pNext;	//!< ̊ĎIuWFNg
public:
	/// RXgN^
	CObserver(void) : m_pSubject(nullptr), m_pNext(nullptr) {}
	/// fXgN^
	virtual ~CObserver(void)	{ release(); }

public:
	_MySubject*				GetSubject(void)			{ return m_pSubject; }	//!< Subject̎擾
	const	_MySubject*		GetSubject(void)	const	{ return m_pSubject; }	//!< Subject̎擾
	_MyObserver*			GetNext(void)				{ return m_pNext; }		//!< Observer̎擾
	const	_MyObserver*	GetNext(void)		const	{ return m_pNext; }		//!< Observer̎擾

public:
	/// Ď̉
	void	release(void)
	{
		if( m_pSubject != nullptr )
		{
			_MySubject* subject = m_pSubject;
			m_pSubject = nullptr;
			subject->DetachObserver(this);
		}
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
