//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMap.h
 * @brief		map t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndMap_H_
#define INCG_IRIS_FndMap_H_

//======================================================================
// include
#include "tree/FndRedBlackTree.h"
#include "FndAllocator.h"
#include "../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	}bvm[h
 * @tparam	KEY	= L[
 * @tparam	VAL	= l
*/
template<typename KEY, typename VAL>
class CPair : public CRBTreeNodeBase
{
	typedef CPair<KEY, VAL>		_Myt;
	typedef VAL	value_type;
	typedef KEY	key_type;
	typedef typename ::cpp0x::arg_type<KEY>::type key_arg_type;	//!< ^
public:
	key_type	first;
	value_type	second;
public:
	CPair(void) {}	//!< @note	bIɋ
	CPair(key_type key, value_type v) : first(key), second(v) {}
	CPair(const _Myt& obj) : first(obj.first), second(obj.second) {}

public:
	bool			operator == (const _Myt& rhs) const	{ return first == rhs.first; }
	bool			operator != (const _Myt& rhs) const	{ return first != rhs.first; }
	bool			operator <  (const _Myt& rhs) const	{ return first <  rhs.first; }
	bool			operator <= (const _Myt& rhs) const	{ return first <= rhs.first; }
	bool			operator >  (const _Myt& rhs) const	{ return first >  rhs.first; }
	bool			operator >= (const _Myt& rhs) const	{ return first >= rhs.first; }

	bool			operator == (key_arg_type rhs) const	{ return first == rhs; }
	bool			operator != (key_arg_type rhs) const	{ return first != rhs; }
	bool			operator <  (key_arg_type rhs) const	{ return first <  rhs; }
	bool			operator <= (key_arg_type rhs) const	{ return first <= rhs; }
	bool			operator >  (key_arg_type rhs) const	{ return first >  rhs; }
	bool			operator >= (key_arg_type rhs) const	{ return first >= rhs; }
};

/**
 * @brief	}bvNX
 * @tparam	KEY	= L[
 * @tparam	VAL	= l
*/
template<typename KEY, typename VAL, typename Allocator_=CNewAllocator<KEY> >
class CMap : private INonCopyable<>
{
	typedef CMap<KEY, VAL, Allocator_>		_Myt;
	typedef typename Allocator_::template rebind< CPair<KEY, VAL> >::type allocator_type;
	typedef CAllocatorInstance<allocator_type>	_MyAllocator;
	typedef CRBTree< CPair<KEY, VAL> >		_Mytree;
	typedef KEY								key_type;

public:
	typedef CPair<KEY, VAL>					pair;

	typedef typename _Mytree::iterator				iterator;
	typedef typename _Mytree::const_iterator		const_iterator;

protected:
	_Mytree	m_tree;
public:
	/// RXgN^
	CMap(void) {}

public:
	/**
	 * @brief	[gRei̎擾
	 * @return	[gReĩCe[^
	 * @{
	*/
	iterator		begin(void)			{ return m_tree.begin(); }
	const_iterator	begin(void)	const	{ return m_tree.begin(); }
	/**
	 * @}
	*/

	/**
	 * @brief	I[Ce[^̎擾
	 * @note	iterator ŒHȂ̂Œ
	 * @return	I[Ce[^
	*/
	iterator		end(void)				{ return m_tree.end(); }
	const_iterator	end(void)		const	{ return m_tree.end(); }

	/**
	 * @brief	I[Ce[^̎擾
	 * @return	I[Ce[^
	*/
	iterator		back(void)				{ return m_tree.back(); }
	const_iterator	back(void)		const	{ return m_tree.back(); }

	/**
	 * @brief	m[h̒ǉ
	 * @param [in]	node	= ǉm[h
	 * @return	ǉꂽCe[^
	*/
	iterator		add(pair node)
	{
		pair* ptr = static_cast<pair*>(_MyAllocator::allocator().alloc(1, 0));
		*ptr = node;
		m_tree.add(ptr);
		return ptr;
	}

	/**
	 * @brief	m[h̒ǉ
	 * @param [in]	ptr	= ǉm[h
	 * @return	ǉꂽCe[^
	*/
	iterator		insert(pair node)
	{
		pair* ptr = static_cast<pair*>(_MyAllocator::allocator().alloc(1, 0));
		*ptr = node;
		m_tree.insert(ptr);
		return ptr;
	}

	/**
	 * @brief	m[h̍폜
	 * @param [in]	pos	= 폜m[h
	 * @return	폜̃[gm[h
	*/
	void			erase(key_type key)
	{
		iterator pos = search(key);
		erase(pos);
	}
	void		erase(iterator pos)
	{
		pair* ptr = &pos;
		m_tree.erase(pos);
		_MyAllocator::allocator().dealloc(ptr);
	}

	/**
	 * @brief	m[h̑S폜
	*/
	void			clear(void)
	{
		for( iterator it=begin(); it != end(); it=begin())
		{
			erase(it);
		}
	}

	/**
	 * @brief	m[ȟ
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	iterator		find(key_type key)	const	{ return m_tree.search(key); }

	/**
	 * @brief	m[ȟ
	 * @param [in]	pos	= Ώۃ[g
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	iterator		find(iterator pos, key_type key)	const	{ return m_tree.search(&pos, key); }

	/**
	 * @brief	m[ȟ
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	template<typename _TT>
	iterator		find(_TT key)	const	{ return m_tree.search(key); }

	/**
	 * @brief	m[ȟ
	 * @param [in]	pos	= Ώۃ[g
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	template<typename _TT>
	iterator		find(iterator pos, _TT key)	const	{ return m_tree.search(&pos, key); }

	/**
	 * @brief	m[ȟ(L[傫ŏ̃m[hԂ)
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇ nullptr
	*/
	iterator		search_more(key_type key)		const	{ return m_tree.search_more(key); }

	/**
	 * @brief	m[ȟ(L[ő̃m[hԂ)
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	iterator		search_less(key_type key)		const	{ return m_tree.search_less(key); }

	/**
	 * @brief	ׂẴm[hɏs
	 * @param [in]	fnuc	= ֐
	*/
	template<typename Func>
	void			foreach(Func func)					{ m_tree.foreach(func); }

	/**
	 * @brief	ׂẴm[hɏs
	 * @param [in]	pos		= [gʒu
	 * @param [in]	fnuc	= ֐
	*/
	template<typename Func>
	void			foreach(iterator pos, Func func)	{ m_tree.foreach(&pos, func); }

	/**
	 * @brief	󂩂ǂ
	 * @return	^Ul
	*/
	bool			empty(void)		const		{ return m_tree.empty(); }

	/**
	 * @brief	m[h̎擾
	*/
	s32				count(void)		const		{ return m_tree.count(); }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
