//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFileBuffer.h
 * @brief		t@Cobt@NXx[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFileBuffer_H_
#define INCG_IRIS_FndFileBuffer_H_

//======================================================================
// include
#include "FndBuffer.h"
#include "../io/FndIFile.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template< typename FILE, typename _Allocator>class CFileBuffer;

//======================================================================
// class
/**
 * @brief	t@CnhNX񋟂wp[
*/
template<typename FILE>
class CFileHandleClassType : public IIrisObject
{
	template<typename F>
	struct type_impl { typedef F type; };
	template<typename F, typename A>
	struct type_impl< CFileBuffer<F, A> > { typedef typename type_impl<F>::type type; };
public:
	typedef typename type_impl<FILE>::type	type;
};

/**
 * @brief	t@Cobt@NX
 * @tparam FILE			= t@CNX
 * @tparam _Allocator	= AP[^
*/
template< typename FILE, typename Allocator_ = CNewAllocator<u8>  >
class CFileBuffer : public IFile, public CBuffer<u8, Allocator_>
{
	typedef typename CFileHandleClassType<FILE>::type		File;

protected:
	u32	m_Pos;	//!< V[Nʒu
public:
	// RXgN^
	CFileBuffer(void) : m_Pos(0)	{}
	// fXgN^
	virtual ~CFileBuffer(void)		{}
public:
	// J
	virtual bool	OpenA(LPCSTR  lpFileName, u32 mode)
	{
		return OpenInternal(lpFileName, mode);
	}
	virtual bool	OpenW(LPCWSTR lpFileName, u32 mode)
	{
		return OpenInternal(lpFileName, mode);
	}
	virtual bool	IsOpen(void)	const	{ return this->is_valid(); }
	// 
	virtual bool	Close(void)				{ this->dealloc(); return true; }
	// seek
	virtual bool	Seek(long offset, int origin)
	{
		u32 end = this->size_of();
		switch( origin )
		{
		case FILE_SEEK_CUR:
			m_Pos += offset;
			//if( m_Pos > end ) m_Pos -= end;
			if( m_Pos > end ) m_Pos = end;
			if( m_Pos < 0 ) m_Pos = 0;
			break;
		case FILE_SEEK_END:
			{
				u32 pos = static_cast<u32>(offset > 0 ? offset : -offset);
				while( pos > end )
				{
					pos -= end;
				}
				m_Pos = end - pos;
			}
			break;
		case FILE_SEEK_SET:
			{
				u32 pos = static_cast<u32>(offset > 0 ? offset : 0);
				while( pos > end )
				{
					pos -= end;
				}
				m_Pos = pos;
			}
			break;
		}
		return true;
	}
	// tell
	virtual s32		Tell(void)		const	{ return static_cast<s32>(m_Pos); }
	// t@CTCY擾
	virtual u32		GetSize(void)	const	{ return this->size_of(); }

	// ǂݍ
	virtual u32		Read(void* buf, u32 size)
	{
		u32 max_size = this->size_of();
		if( size + m_Pos > max_size ) size = max_size - m_Pos;
		memcpy(buf, this->ptr() + m_Pos, size);
		m_Pos += size;
		return size;
	}
	virtual u32		ReadAsync(void* buf, u32 size)	{ return Read(buf, size); }
	// 
	virtual u32		Write(const void* /*buf*/, u32 /*size*/)	{ return 0; }	// TODO : ݂͂ЂƂ܂֎~
	virtual u32		WriteAsync(const void* buf, u32 size)		{ return Write(buf, size); }

private:
	template<typename CHARTYPE_>
	bool	OpenInternal(const CHARTYPE_* lpFileName, u32 mode)
	{
		File file;
		if( !file.Open(lpFileName, mode) ) return false;
		if( !alloc(file.GetSize()) ) return false;
		if( !file.Read(this->ptr(), this->size_of()) )
		{
			this->dealloc();
			return false;
		}
		return true;
	}
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
