//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndDuration.h
 * @brief		duration t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndDuration_H_
#define INCG_IRIS_FndDuration_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"
#include "../../ml/ratio/iml_ratio.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	duration
 * @tparam _TN	= ľ^
 * @tparam _R	= ratio
*/
template<typename _TN, class _R>
class CDuration : public IIrisObject
{
	IRIS_STATIC_ASSERT( iml::is_ratio<_R>::value );

	typedef _TN	value_type;
	typedef _TN	*value_ptr;
	typedef _TN	&value_ref;
	typedef _R	period;

	typedef CDuration<_TN, _R>	_Myt;
private:
	value_type	m_rep;

public:
	/**
	 * @name	RXgN^
	 * @{
	*/
	CDuration(void) {}
	CDuration(const value_type& d) : m_rep(d) {}
	CDuration(const _Myt& rhs) : m_rep(rhs.m_rep) {}
	/**
	 * @}
	*/


public:
	/**
	 * @brief	l̎擾
	 * @return	period Pʂ̒l
	*/
	value_type			count(void)					{ return m_rep; }
	const value_type&	count(void)	const			{ return m_rep; }

public:
	/**
	 * @name	operator
	 * @{
	*/
	_Myt&	operator = (const _Myt& rhs)	{ if( &rhs != this ) this->m_rep = rhs.m_rep; return *this; }

	_Myt	operator + (void) const			{ return *this; }
	_Myt	operator - (void) const			{ return _Myt(-m_rep); }
	_Myt	operator ++(int)				{ return _Myt(m_rep++); }
	_Myt&	operator ++(void)				{ ++m_rep; return *this; }
	_Myt	operator --(int)				{ return _Myt(m_rep--); }
	_Myt&	operator --(void)				{ --m_rep; return *this; }

	_Myt&	operator +=(const _Myt& d)		{ m_rep += d.count(); return *this; }
	_Myt&	operator -=(const _Myt& d)		{ m_rep -= d.count(); return *this; }

	_Myt	operator * (const value_type& rhs)	const	{ return _Myt(m_rep * rhs); }
	_Myt&	operator *=(const value_type& rhs)			{ m_rep *= rhs; return *this; }
	_Myt	operator / (const value_type& rhs)	const	{ return _Myt(m_rep / rhs); }
	_Myt&	operator /=(const value_type& rhs)			{ m_rep /= rhs; return *this; }
	_Myt	operator % (const value_type& rhs)	const	{ return _Myt(m_rep % rhs); }
	_Myt&	operator %=(const value_type& rhs)			{ m_rep %= rhs; return *this; }
	_Myt	operator % (const _Myt& rhs)	const		{ return _Myt(m_rep % rhs.count()); }
	_Myt&	operator %=(const _Myt& rhs)				{ m_rep %= rhs.count(); return *this; }
	/**
	 * @}
	*/
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
