//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBuffer.h
 * @brief		obt@NXx[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBuffer_H_
#define INCG_IRIS_FndBuffer_H_

//======================================================================
// include
#include "FndAllocator.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	obt@NX
 * @tparam TN_			= ^
 * @tparam Allocator_	= AP[^
*/
template< typename TN_=u8, typename Allocator_ = CNewAllocator<TN_> >
class CBuffer : private INonCopyable<>
{
protected:
	typedef TN_		value_type;
	typedef TN_		*value_ptr;
	typedef TN_		&value_ref;
	typedef typename Allocator_::template rebind<TN_>::type allocator_type;
	typedef CAllocatorInstance<allocator_type>	Allocator;
	typedef CBuffer<TN_, Allocator_>	_Myt;
protected:
	value_ptr	m_pBuffer;	//!< obt@
	u32			m_Size;		//!< obt@TCY
public:
	// RXgN^
	CBuffer(void) : m_pBuffer(nullptr), m_Size(0) {}
	explicit CBuffer(u32 size, s32 arg=0) : m_pBuffer(nullptr), m_Size(0) { alloc(size, arg); }
	//! fXgN^
	virtual	~CBuffer(void)					{ dealloc(); }

public:
	/**
	 * @name operator
	 * @{
	*/
	operator	value_ptr			(void)			{ return ptr(); }
	operator	const value_type*	(void)	const	{ return ptr(); }
	operator	void*				(void)			{ return ptr(); }
	operator	const void*			(void)	const	{ return ptr(); }
	/**
	 * @}
	*/

public:
	/// obt@̊m
	bool	alloc(u32 size, s32 arg=0)
	{
		return resize(size, arg);
	}
	/// TCY
	bool	resize(u32 size, s32 arg=0)
	{
		if( m_Size == size ) return true;
		return realloc(size, arg);
	}
	/// obt@̍Ċm
	bool	realloc(u32 size, s32 arg=0)
	{
		dealloc();
		m_pBuffer = pointer_cast<value_ptr>(Allocator::allocator().alloc(size, arg));
		if( m_pBuffer == nullptr ) return false;
		m_Size = size;
		return true;
	}
	/// obt@̉
	void	dealloc(void)
	{
		Allocator::allocator().dealloc(m_pBuffer);
		m_Size = 0;
		m_pBuffer = nullptr;
	}

	/// obt@tB
	void	fill(value_type value)
	{
		value_ptr buf = m_pBuffer;
		for( u32 i=0; i < m_Size; ++i, ++buf )
		{
			*buf = value;
		}
	}

public:
	bool	is_valid(void)	const	{ return m_pBuffer != nullptr; }
public:
	/**
	 * @name ANZT
	 * @{
	*/
	value_ptr			ptr(void)				{ return m_pBuffer; }	//!< obt@AhX̎擾
	const value_type*	ptr(void)		const	{ return m_pBuffer; }	//!< obt@AhX̎擾
	u32					length(void)	const	{ return m_Size; }		//!< obt@TCY̎擾
	u32					size(void)		const	{ return m_Size; }		//!< obt@TCY̎擾
	u32					size_of(void)	const	{ return m_Size*sizeof(value_type); }		//!< obt@byteTCY̎擾
	/**
	 * @}
	*/

public:
	/**
	 * @brief	
	*/
	void			swap(_Myt& rhs)
	{
		value_ptr p = this->m_pBuffer;
		this->m_pBuffer = rhs.m_pBuffer;
		rhs.m_pBuffer = p;
		u32 size = this->m_Size;
		this->m_Size = rhs.m_Size;
		rhs.m_Size = size;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
