//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRijndael.h
 * @brief		RijndaelÍNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRijndael_H_
#define INCG_IRIS_FndRijndael_H_

//======================================================================
// include
#include "FndCipherBase.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// prefix
// == 0 : e[uȂ
// == 1 : e[u1(rbg̉]́AIɎs)
// == 4 : e[u4(rbg̉]e[up)
// not defined : using .cpp config
//#define	_IRIS_RIJNDAEL_TABLE		0

// NX肷
//#define _IRIS_RIJNDAEL_BLK		128
//#define _IRIS_RIJNDAEL_KEY		128

//======================================================================
// declare
template<u32 _BLB, u32 _KYB> class CRijndael;

//======================================================================
// typedef
typedef class CRijndael<128, 128>		CRijndael128x128;	//!< RijndaelÍNX(block=128, key=128)
typedef class CRijndael<128, 192>		CRijndael128x192;	//!< RijndaelÍNX(block=128, key=192)
typedef class CRijndael<128, 256>		CRijndael128x256;	//!< RijndaelÍNX(block=128, key=256)
typedef class CRijndael<192, 128>		CRijndael192x128;	//!< RijndaelÍNX(block=192, key=128)
typedef class CRijndael<192, 192>		CRijndael192x192;	//!< RijndaelÍNX(block=192, key=192)
typedef class CRijndael<192, 256>		CRijndael192x256;	//!< RijndaelÍNX(block=192, key=256)
typedef class CRijndael<256, 128>		CRijndael256x128;	//!< RijndaelÍNX(block=256, key=128)
typedef class CRijndael<256, 192>		CRijndael256x192;	//!< RijndaelÍNX(block=256, key=192)
typedef class CRijndael<256, 256>		CRijndael256x256;	//!< RijndaelÍNX(block=256, key=256)

#ifdef _IRIS_RIJNDAEL_BLK
#define _IRIS_RIJNDAEL_DEF_BLK	_IRIS_RIJNDAEL_BLK
#else
#define _IRIS_RIJNDAEL_DEF_BLK	128
#endif
#ifdef _IRIS_RIJNDAEL_KEY
#define _IRIS_RIJNDAEL_DEF_KEY	_IRIS_RIJNDAEL_KEY
#else
#define _IRIS_RIJNDAEL_DEF_KEY	128
#endif
typedef class CRijndael<_IRIS_RIJNDAEL_DEF_BLK, _IRIS_RIJNDAEL_DEF_KEY>	CDefRijndael;	//!< ftHgݒRijndaelÍNX

//======================================================================
// class
/**
 * @brief	RijndaelÍNX
 * @param _BLB	= ubNrbg
 * @param _KYB	= rbg
*/
template<u32 _BLB, u32 _KYB>
class CRijndael : public IBlockCipher
{
public:
	typedef enum
	{
		KBITS		= _KYB,			//!< rbg
		NK			= KBITS/32,		//!< 
		KEYSIZE		= KBITS/8,		//!< oCg

		BBITS		= _BLB,			//!< ubNrbg
		NB			= BBITS/32,		//!< ubN[h
		BLOCKSIZE	= BBITS/8,		//!< ubNoCg

		NR			= (((NB/NK)*NB + (NK/NB)*NK)/(NB/NK+NK/NB) + 6),	//!< Eh ((NK > NB ? NK : NB) + 6)
		KS_LENGTH	= NB*(NR+1)											//!< L[XPW[[h
	} TYPES;

private:
	IRIS_STATIC_ASSERT( (_KYB & 0x1F) == 0 );
	IRIS_STATIC_ASSERT( (_BLB & 0x1F) == 0 );
	IRIS_STATIC_ASSERT( NB >= 4 && NB <= 8 );	// NB > 8 ͖Ή

	s32		m_Round;
	u32		m_KeySch[KS_LENGTH];	//!< L[XPW[
public:
	// RXgN^
	CRijndael(void);
	// fXgN^
	virtual ~CRijndael(void)	{}

public:
	/// ubNoCg̎擾
	virtual u32		GetBlockSize(void)	const	{ return BLOCKSIZE; }
	/// oCg̎擾
	virtual u32		GetKeySize(void)	const	{ return KEYSIZE; }
public:
	// ̍쐬
	virtual bool	CreateKeys(const u8* pkey, u32 nSize);
public:
	// Í
	virtual bool	EncryptBlock(u8* dst, const u8* src);
	// 
	virtual bool	DecryptBlock(u8* dst, const u8* src);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
