//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRSA32.cpp
 * @brief		RSAÍAt@C(32bit)
 *				(p,q,eɓKł鐔Ȃ̂ŁAp)
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndRSA32_CPP_

//======================================================================
// include
#include "FndRSA32.h"
#include "../../math/MathCommonMulDiv.h"
#include "../../math/MathPower.h"
#include "../../iris_math.h"
#include <stdio.h>

//======================================================================
// define
#define RSA32_WARNING(str_)	printf("WARNING : CRSA3232 : " str_)

namespace iris {
namespace fnd
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRSA32::CRSA32(void)
: m_p(3)
, m_q(7)
, m_d(11)
, m_e(5)
, m_n(21)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
//CRSA32::~CRSA32(void)
//{
//}

/**********************************************************************//**
 *
 * ǐj
 *
 ----------------------------------------------------------------------
 * @param [in]	p	= 閧1iɑ傫ȑf𐄏j
 * @param [in]	q	= 閧2iɑ傫ȑf𐄏j
 * @param [in]	e	= J1ilcm(p-1,q-1) > e && lcm(p-1,q-1) ƌ݂ɑfȐj
 * @return	
*//***********************************************************************/
bool CRSA32::Init(u32 p, u32 q, u32 e)
{
	// (p*q) == (p-1)(q-1)
	s64 l = math::lcm( (p-1), (q-1) );	// l = (p-1)*(q-1)ł悢
	if( l <= e )
	{
		RSA32_WARNING( "Init : m <= e.\n" );
		return false;
	}
	if( math::gcd(l, (s64)e) != 1 )
	{
		RSA32_WARNING( "Init : gcd(m, e) != 1.\n" );
		return false;
	}
	u64 n = (u64)p*q;
	if( n >= 0xFFFFFFFF )
	{
		RSA32_WARNING( "Init : p*q overflow.\n" );
		return false;
	}
	m_p = p;
	m_q = q;
	m_e = e;
	m_n = p*q;

	// dZo
	s64 x1 = 1, y1 = 0, z1 = l;
	s64 x2 = 0, y2 = 1, z2 = e;
	while(z2 != 0)
	{
		s64 a = z1/z2;
		s64 x3 = x1 - a*x2;
		s64 y3 = y1 - a*y2;
		s64 z3 = z1 - a*z2;
		x1 = x2;
		y1 = y2;
		z1 = z2;
		x2 = x3;
		y2 = y3;
		z2 = z3;
	}
	if( y1 < 0 ) y1 += l;
	m_d = (u32)y1;
	return true;
}

/**********************************************************************//**
 *
 * Í
 *
 ----------------------------------------------------------------------
 * @param [in]	m	= 
 * @return	Í
*//***********************************************************************/
u32 CRSA32::Encrypt(u32 m)
{
	if( m >= m_n ) return m;
	return math::mod_pow<u32, u64>(m, m_e, m_n);
	//u64 _m = (u64)math::bin_pow((u64)m, (u64)m_e);
	//return (u32)(_m % m_n);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	c	= Í
 * @return	
*//***********************************************************************/
u32 CRSA32::Decrypt(u32 c)
{
	if( c >= m_n ) return c;
	return math::mod_pow<u32, u64>(c, m_d, m_n);
	//u64 _c = (u64)math::bin_pow((u64)c, (u64)m_d);
	//return (u32)(_c % m_n);
}

}	// end of namespace fnd
}	// end of namespace iris
