//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRSA.h
 * @brief		RSAÍAt@C
 *				RSAASY[c = m(e) mod n.]́A݃CZXt[łB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRSA_H_
#define INCG_IRIS_FndRSA_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../math/MathCommonMulDiv.h"
#include "../../math/MathPower.h"

#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../ml/iml_type_select.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	RSAÍNX
 * @tparam	_Type	= ^
 * @tparam	_Large	= vZp^
*/
template<typename _Type, typename _Large=_Type>
class CRSA : public IIrisObject
{
	typedef typename ::iml::type_select< ::cpp0x::is_scalar<_Type>::value, _Type, const _Type& >::type _ArgType;	//!< ^
//	typedef typename _Type _ArgType;
//	_Type	m_p;	//!< private key (prime number)
//	_Type	m_q;	//!< private key (prime number)
	_Type	m_d;	//!< private key (Decrypt key)
protected:
	_Type	m_e;	//!< public key (Encrypt key)(bit]藧ĂȂl悢)
	_Type	m_n;	//!< public key (valid space)
public:
	/// RXgN^
	CRSA(void)
		: m_n(21), m_e(5), m_d(11)
		//, m_p(3), m_q(7)
	{}
	// fXgN^
	//~CRSA(void)	{}

public:
	/**
	 * @breif	
	 * @note	e ́A p-1  q-1 ̍ŏ{ƌ݂ɑfȐłȂ΂܂B
	 * @param	p	= private key (prime number)
	 * @param	q	= private key (prime number)
	 * @param	e	= public key
	*/
	bool	Init(_ArgType p, _ArgType q, _ArgType e)
	{
		_Type l = math::lcm( (p-1), (q-1) );
		if( l <= e )						{ printf( "CRSA Init : lcm((p-1), (q-1)) <= e.\n" ); return false; }
		if( math::gcd(l, e) != (_Type)1 )	{ printf( "CRSA Init : m = lcm((p-1), (q-1)); gcd(m, e) != 1.\n" ); return false; }

		//m_p = p; m_q = q;
		m_e = e; m_n = p*q;
		// dZo
		_Type x1 = 1, y1 = 0, z1 = l;
		_Type x2 = 0, y2 = 1, z2 = e;
		while(z2 != 0)
		{
			_Type a = z1/z2;
#if 0
			_Type tmp = x2;
			x2 = x1 - a*x2;
			x1 = tmp;
			tmp = y2;
			y2 = y1 - a*y2;
			y1 = tmp;
			tmp = z2;
			z2 = z1 - a*z2;
			z1 = tmp;
#else
			_Type x3 = x1 - a*x2;
			_Type y3 = y1 - a*y2;
			_Type z3 = z1 - a*z2;
			x1 = x2; y1 = y2; z1 = z2;
			x2 = x3; y2 = y3; z2 = z3;
#endif
		}
		if( y1 < 0 ) y1 += l;
		m_d = y1;
		return true;
	}
	/// Í
	_Type	Encrypt(_ArgType m)
	{
		if( m >= m_n ) return m;
		return math::mod_pow<_Type, _Large>(m, m_e, m_n);
		//_Large _m = math::bin_pow((_Large)m, (_Large)m_e);
		//return (_Type)(_m % m_n);
	}
	/// 
	_Type	Decrypt(_ArgType c)
	{
		if( c >= m_n ) return c;
		return math::mod_pow<_Type, _Large>(c, m_d, m_n);
		//_Large _c = math::bin_pow((_Large)c, (_Large)m_d);
		//return (_Type)(_c % m_n);
	}

public:
	// ̎擾
	_Type	GetPublicKeyN(void)		const	{ return m_n; }	//!< JN̎擾
	_Type	GetPublicKeyE(void)		const	{ return m_e; }	//!< JE̎擾
	_Type	GetPrivateKeyD(void)	const	{ return m_d; }	//!< JN̎擾
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
