//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRSA.cpp
 * @brief		RSAÍAt@C
 *				RSAASY[c = m(e) mod n.]́A݃CZXt[łB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndRSA_CPP_

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "FndRSA.h"
#include "../types/FndLargeVariable.h"
#include "../types/FndVLVariable.h"
#include "../../xpi/os/XpiSysTime.h"
#include "../../unit/UnitCore.h"
#include "../../iris_iostream.h"
#include "../../iris_using.h"

#define UNITTEST		1

#define RSA_TEST_BIT	640

#if UNITTEST
//======================================================================
// test
IRIS_UNITTEST(CFndRSAUnitTest, Func)
{
#if	(RSA_TEST_BIT != 0)

#if	(RSA_TEST_BIT == 640)
	typedef iris::fnd::CLargeVariable<641>	value_type;
//	typedef iris::fnd::CVLVariable			value_type;
	// RSA - 640
	value_type p("1634733645809253848443133883865090859841783670033092312181110852389333100104508151212118167511579");
	value_type q("1900871281664822113126851573935413975471896789968515493666638539088027103802104498957191261465571");
#else
#undef RSA_TEST_BIT
#define RSA_TEST_BIT	0
#endif
#endif

#if	RSA_TEST_BIT
	char str[1024];
	typedef iris::fnd::CLargeVariable<value_type::BITS*2>	large_type;
//	typedef iris::fnd::CVLVariable							large_type;
	typedef iris::fnd::CRSA<value_type, large_type>	RSA;
	RSA rsa;
	p.ToString(str, 1024);
	std::cout << "p = " << str << std::endl;
	q.ToString(str, 1024);
	std::cout << "q = " << str << std::endl;
	u64	tick00 = CSysTick::GetTick();
	bool ret = rsa.Init(p, q, 101);
	u64	tick01 = CSysTick::GetTick();
	printf("CRSA Init :  %fb\n", CSysTick::TicksToMilliSeconds(CSysTick::DiffTick(tick01, tick00))/1000.0f );
	if( ret  )
	{
		rsa.GetPrivateKeyD().ToString(str, 1024);
		std::cout << "d = " << str << std::endl;
		rsa.GetPublicKeyN().ToString(str, 1024);
		std::cout << "n = " << str << std::endl;
		for( value_type i = 0; i < rsa.GetPublicKeyN(); ++i )
		{
			u64	tick0 = CSysTick::GetTick();
			value_type c = rsa.Encrypt( i );
			value_type m = rsa.Decrypt( c );
			u64	tick1 = CSysTick::GetTick();
			printf(" %fb\n", CSysTick::TicksToMilliSeconds(CSysTick::DiffTick(tick1, tick0))/1000.0f );
			if( i != m )
			{
				std::cout << "CRSA failed. " << (IrisU32)i << std::endl;
				goto end;
			}
#if		!defined(_IRIS_NOT_SUPPORT_IOSTREAM)
			std::cout << i << std::endl;
#endif
		}
		std::cout << "CRSA succeeded." << std::endl;
	}
end:

#else
	typedef iris::fnd::CLargeVariable<1024>			value_type;
	typedef iris::fnd::CRSA<value_type>				RSA;

	while( 1 )
	{
		RSA rsa;
		s32 p = 3, q = 7, e = 5;
		std::cout << "JL[[p]ifj͂Ă" << std::endl;
		std::safe_cin >> p;
		std::cout << "JL[[q]ifj͂Ă" << std::endl;
		std::safe_cin >> q;
		std::cout << "JL[[e]͂Ă" << std::endl;
		std::safe_cin >> e;
		if( rsa.Init( p, q, e ) )
		{
			std::cout << "d = " << rsa.GetPrivateKeyD() << std::endl;
			std::cout << "n = " << rsa.GetPublicKeyN() << std::endl;
			for( value_type i = 0; i < rsa.GetPublicKeyN(); ++i )
			{
				value_type c = rsa.Encrypt( i );
				value_type m = rsa.Decrypt( c );
				if( i != m )
				{
					std::cout << "CRSA failed. " << (u32)i << std::endl;
					goto end;
				}
			}
			std::cout << "CRSA succeeded." << std::endl;
		}
end:
		s32 flag=0;
		std::cout << "Iꍇ́A0 ͂ĂB" << std::endl;
		std::safe_cin >> flag;
		if( flag == 0 ) break;
	}
#endif
	return;
}
#endif

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
