//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndEncoding.h
 * @brief		R[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndEncoding_H_
#define INCG_IRIS_FndEncoding_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

typedef enum CODEPAGE
{
	ENC_CP_UNKOWN	= -1,		//!< s
	ENC_CP_W31J		= 932,		//!< CP_932
	ENC_CP_UTF16LE	= 1200,		//!< UTF16
	ENC_CP_UTF16BE	= 1201,		//!< UTF16(rbOGfBA)
	ENC_CP_ASCII	= 20127,	//!< US ASCII
	ENC_CP_JIS		= 50220,	//!< iso-2022-jp
	ENC_CP_JISCS	= 50221,	//!< csiso-2022-jp(JIS 1byte J^Ji)
	ENC_CP_EUC		= 51932,	//!< EUC
	ENC_CP_UTF7		= 65000,	//!< UTF7
	ENC_CP_UTF8		= 65001,	//!< UTF8
} CP;

//======================================================================
// class
/**
 * @brief	R[hNX
*/
class CEncoding : public IIrisObject
{
public:
	// R[h
	static CODEPAGE	GetEncoding(const void* lpBuffer, size_t size);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
