//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_volatile_traits.hpp
 * @brief		volatile t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_volatile_traits_HPP_
#define INCG_IRIS_cpp0x_volatile_traits_HPP_

//======================================================================
// include
#include "cpp0x_type_traits_def.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_volatile;		// volatileǂ
template<typename TN_>class add_volatile;		// TN_  volatileǉ
template<typename TN_>class remove_volatile;	// TN_volatile폜

//======================================================================
// class
/// is volatile
template<typename TN_>
class is_volatile
{
	template<typename TT_> struct volatile_trait : public iml::detail::false_type	{};
	template<typename TT_> struct volatile_trait<volatile TT_> : public iml::detail::true_type	{};
public:
	enum { value = volatile_trait<TN_>::value };
};

/// add volatile trait
IRIS_SET_TYPE_TRAITS_DEC(add_volatile, volatile);
/// remove volatile trait
IRIS_REMOVE_TYPE_TRAITS_DEC(remove_volatile, volatile);

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
