//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_value_traits.hpp
 * @brief		l t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_value_traits_HPP_
#define INCG_IRIS_cpp0x_value_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class zero_traits;		// 0 
template<typename TN_>class one_traits;			// 1 

//======================================================================
// define
#define IRIS_VALUE_TRAITS_DEC(name)							\
	template<typename TN_>class name##_traits_impl {		\
		public:												\
			static const TN_	value;						\
	};														\
	template<typename TN_>class name##_traits {				\
		public:												\
			typedef typename remove_cv<TN_>::type	type;	\
			static const type	value;						\
	};														\
	template<typename TN_>									\
	const typename name##_traits<TN_>::type	name##_traits<TN_>::value	\
		= name##_traits_impl<typename remove_cv<TN_>::type>::value


//======================================================================
// class
/// 0 
IRIS_VALUE_TRAITS_DEC(zero);
/// 1 
IRIS_VALUE_TRAITS_DEC(one);

template<typename TN_>
const TN_	zero_traits_impl<TN_>::value	= 0;
template<typename TN_>
const TN_	one_traits_impl<TN_>::value		= 1;

}	// end of namespace cpp0x

#undef IRIS_VALUE_TRAITS_DEC

#endif
