//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_trivial_traits.hpp
 * @brief		I t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_trivial_traits_HPP_
#define INCG_IRIS_cpp0x_trivial_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_pod_traits.hpp"
#include "../../ml/iml_op.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class has_trivial_constructor;	// IȃRXgN^邩
template<typename TN_>class has_trivial_copy;			// IȃRs[RXgN^邩
template<typename TN_>class has_trivial_assign;			// Iȑ邩
template<typename TN_>class has_trivial_destructor;		// IȃfXgN^邩

//======================================================================
// class
/// has trivial constructor
template<typename TN_>
class has_trivial_constructor
{
public:
	enum { value = iml::op_or< is_pod<TN_>::value
					, IRIS_HAS_TRIVIAL_CONSTRUCTOR(TN_) >::value };
};

/// has trivial copy
template<typename TN_>
class has_trivial_copy
{
public:
	enum { value = iml::op_and< iml::op_or< is_pod<TN_>::value
								, IRIS_HAS_TRIVIAL_COPY(TN_) >::value
						, iml::op_not< is_volatile<TN_>::value >::value
					>::value };
};

/// has trivial assign
template<typename TN_>
class has_trivial_assign
{
public:
	enum { value = iml::op_and< iml::op_or< is_pod<TN_>::value
								, IRIS_HAS_TRIVIAL_ASSIGN(TN_) >::value
						, iml::op_not< is_const<TN_>::value >::value
						, iml::op_not< is_volatile<TN_>::value >::value
					>::value };
};

/// has trivial destructor
template<typename TN_>
class has_trivial_destructor
{
public:
	enum { value = iml::op_or< is_pod<TN_>::value
					, IRIS_HAS_TRIVIAL_DESTRUCTOR(TN_) >::value };
};
}	// end of namespace cpp0x

#endif
