//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_reference_traits.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_reference_traits_HPP_
#define INCG_IRIS_cpp0x_reference_traits_HPP_

//======================================================================
// include
#include "cpp0x_type_traits_def.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_reference;		// QƂǂ
template<typename TN_>class add_reference;		// TN_  QƓǉ
template<typename TN_>class remove_reference;	// TN_QƓ폜

//======================================================================
// class
/// is reference
template<typename TN_>
class is_reference
{
	template<typename TT_> struct reference_trait : public iml::detail::false_type	{};
	template<typename TT_> struct reference_trait<TT_&> : public iml::detail::true_type {};
public:
	enum { value = reference_trait<TN_>::value };
};

// add reference trait
IRIS_SET_TYPE_TRAITS_DEC(add_reference, &);
// remove reference trait
IRIS_REMOVE_TYPE_TRAITS_DEC(remove_reference, &);

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
