//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_pod_traits.hpp
 * @brief		POD^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_pod_traits_HPP_
#define INCG_IRIS_cpp0x_pod_traits_HPP_

//======================================================================
// include
#include "cpp0x_scalar_traits.hpp"
#include "cpp0x_void_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_pod;	// POD^ǂ

//======================================================================
// class
/// is same
template<typename TN_>
class is_pod
{
	template<typename TT_> struct pod_trait
	{
		enum { value = iml::op_or< is_scalar<TT_>::value
					, is_void<TT_>::value
					, IRIS_IS_POD(TT_) >::value };
	};
	template<typename TT_, size_t SIZE> struct pod_trait<TT_[SIZE]> : public pod_trait<TT_> {};

	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = pod_trait<type>::value };
};

}	// end of namespace cpp0x

#endif
