//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_extent_traits.hpp
 * @brief		z t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_extent_traits_HPP_
#define INCG_IRIS_cpp0x_extent_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_, size_t N>class extent;	// z̎
template<typename TN_>class remove_extent;		// z̎P폜
template<typename TN_>class remove_all_extent;	// z̎Sč폜

//======================================================================
// class
/// extent
template<typename TN_, size_t N=0>
class extent
{
	template<typename TT_, size_t NN>
	struct extent_trait { enum { value = 0 }; };

	template<typename TT_, size_t R, size_t NN>
	struct extent_trait<TT_[R], NN> { enum { value = extent_trait<TT_, NN-1>::value }; };

	template<typename TT_, size_t R>
	struct extent_trait<TT_[R], 0> { enum { value = R }; };

#if	!defined(__MWERKS__)
	template<typename TT_, size_t NN>
	struct extent_trait<TT_[], NN> { enum { value = extent_trait<TT_, NN-1>::value }; };

	template<typename TT_>
	struct extent_trait<TT_[], 0> { enum { value = 0 }; };
#endif

	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = extent_trait<type, N>::value };
};

/// remove extent
template<typename TN_>
class remove_extent
{
	template<typename TT_>
	struct rem_extent { typedef TT_	type; };

	template<typename TT_, size_t R>
	struct rem_extent<TT_[R]> { typedef TT_	type; };

#if	!defined(__MWERKS__)
	template<typename TT_>
	struct rem_extent<TT_[]> { typedef TT_	type; };
#endif

public:
	typedef typename rem_extent<TN_>::type type;
};

/// remove all extent
template<typename TN_>
class remove_all_extent
{
	template<typename TT_>
	struct rem_extent { typedef TT_	type; };

	template<typename TT_, size_t R>
	struct rem_extent<TT_[R]>
	{
		typedef typename rem_extent<TT_>::type type;
	};

#if	!defined(__MWERKS__)
	template<typename TT_>
	struct rem_extent<TT_[]>
	{
		typedef typename rem_extent<TT_>::type type;
	};
#endif

public:
	typedef typename rem_extent<TN_>::type type;
};

}	// end of namespace cpp0x

#endif
