//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_empty_traits.hpp
 * @brief		 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_empty_traits_HPP_
#define INCG_IRIS_cpp0x_empty_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_class_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_empty;		// 󂩂ǂ

//======================================================================
// class
/// is empty
template<typename TN_>
class is_empty
{
	template<typename TT_>struct is_empty_helper_t1 : public TT_
	{
		is_empty_helper_t1();
		int i[256];
	};
	struct is_empty_helper_t2	{ int i[256]; };

	template<typename TT_, bool ic = false>struct is_empty_helper : public iml::detail::false_type {};
	template<typename TT_>struct is_empty_helper<TT_, true>
	{
		enum { value = (sizeof(is_empty_helper_t1<TT_>) == sizeof(is_empty_helper_t2)) };
	};

	template<typename TT_>struct is_empty_impl
	{
		typedef typename remove_cv<TT_>::type	ncvt;
		enum { value = iml::op_or<is_empty_helper<ncvt, is_class<TT_>::value>::value
			, IRIS_IS_EMPTY(ncvt)>::value };
	};

public:
	enum { value = is_empty_impl<TN_>::value };
};

}	// end of namespace cpp0x

#endif
