//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_cv_traits.hpp
 * @brief		const volatile t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_cv_traits_HPP_
#define INCG_IRIS_cpp0x_cv_traits_HPP_

//======================================================================
// include
#include "cpp0x_const_traits.hpp"
#include "cpp0x_volatile_traits.hpp"
#include "../../ml/op/iml_op_and.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_cv;		// TN_  const volatileǂ
template<typename TN_>class add_cv;		// TN_  const volatileǉ
template<typename TN_>class remove_cv;	// TN_const volatile폜

//======================================================================
// class
/// is const volatile trait
template<typename TN_>
class is_cv
{
public:
	enum { value = iml::op_and< is_const<TN_>::value, is_volatile<TN_>::value >::value };
};

/// add const volatile trait
template<typename TN_>
class add_cv
{
public:
	typedef typename add_const< typename add_volatile<TN_>::type >::type	type;
};

/// remove const volatile trait
template<typename TN_>
class remove_cv
{
public:
	typedef typename remove_const< typename remove_volatile<TN_>::type >::type	type;
};

}	// end of namespace cpp0x

#endif
