//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_convertible_traits.hpp
 * @brief		^ϊ`FbN t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_convertible_traits_HPP_
#define INCG_IRIS_cpp0x_convertible_traits_HPP_

//======================================================================
// include
#include "cpp0x_abstract_traits.hpp"
#include "cpp0x_arithmetic_traits.hpp"
#include "cpp0x_array_traits.hpp"
#include "cpp0x_void_traits.hpp"
#include "cpp0x_reference_traits.hpp"
#include "../../ml/iml_op.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename From, typename To>class is_convertible;		// ^ϊ\ǂ

//======================================================================
// class
/// is convertible
template<typename From, typename To>
class is_convertible
{
	template<typename TFrom, typename TMP>struct does_convertible_exit
	{
		template<typename TTo>struct result
		{
			static iml::detail::no_t	check(...);
			static iml::detail::yes_t	check(TTo);
			static TFrom				from_;
			enum { value = is_iml_yes_t(check(from_)) };
		};
	};
	template<typename TMP>struct does_convertible_exit<void, TMP>
	{
		template<typename TTo>struct result
		{
			enum { value = is_void<TTo>::value };
		};
	};

	template<typename TFrom, typename TTo>struct is_convertible_base_impl
		: public does_convertible_exit<TFrom, void>:: template result<TTo>	{};

	template<typename TFrom, typename TTo>struct is_convertible_impl
	{
		typedef typename add_reference<TFrom>::type	ref_type;
		enum { value = iml::op_and< is_convertible_base_impl<ref_type, TTo>::value
						, iml::op_not< is_array<TTo>::value >::value
						>::value
		};
	};

	template<bool trivaial1, bool trivaial2, bool abstract_target, typename TMP>
	struct is_convertible_select
	{
		template<class TF_, class TT_>struct rebind
		{
			typedef is_convertible_impl<TF_, TT_>	type;
		};
	};

	template<typename TMP>
	struct is_convertible_select<true, true, false, TMP>
	{
		template<class TF_, class TT_>struct rebind
		{
			typedef iml::detail::true_type	type;
		};
	};

	template<typename TMP>
	struct is_convertible_select<false, false, true, TMP>
	{
		template<class TF_, class TT_>struct rebind
		{
			typedef iml::detail::false_type	type;
		};
	};

	template<typename TMP>
	struct is_convertible_select<true, false, true, TMP>
	{
		template<class TF_, class TT_>struct rebind
		{
			typedef iml::detail::false_type	type;
		};
	};

	template<typename TFrom, typename TTo>struct is_convertible_dispach
	{
		typedef is_convertible_select<
			  is_arithmetic<TFrom>::value
			, is_arithmetic<TTo>::value
			, is_abstract<TTo>::value
			, void>		selector;
		typedef typename selector::template rebind<TFrom, TTo>	binder;
		typedef typename binder::type		type;
	};

public:
	enum { value = is_convertible_dispach<From, To>::type::value };
};

}	// end of namespace cpp0x

#endif
