//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_array_traits.hpp
 * @brief		z t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_array_traits_HPP_
#define INCG_IRIS_cpp0x_array_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class is_array;			// z񂩂ǂ

//======================================================================
// class
/// is array
template<typename TN_>
class is_array
{
	template<typename TT_> struct array_trait
		: public iml::detail::false_type		{};
	template<typename TT_> struct array_trait<TT_[]>
		: public iml::detail::true_type			{};
	template<typename TT_, size_t Nx> struct array_trait<TT_[Nx]>
		: public iml::detail::true_type			{};

	typedef typename remove_cv<TN_>::type	type;
public:
	enum { value = array_trait<type>::value };
};

template<typename TN_>
class array_traits
{
	template<typename TT_>struct impl
	{
		typedef typename TT_::value_type	element;
	};
	template<typename TT_, size_t Nx>struct impl<TT_[Nx]>
	{
		typedef TT_	element;
	};
	template<typename TT_>struct impl<TT_*>
	{
		typedef TT_	element;
	};
public:
	typedef typename impl<TN_>::element	element;
};

}	// end of namespace cpp0x

#endif
