//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_align_traits.hpp
 * @brief		ACg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_align_traits_HPP_
#define INCG_IRIS_cpp0x_align_traits_HPP_

//======================================================================
// include
#include "../../ml/iml_type_select.hpp"
#include "../../preprocessor/program/PPCat.h"
#include "../../preprocessor/program/arithmetic/PPInc.h"
#include "../../iris_debug.h"

namespace cpp0x
{

//======================================================================
// declare
template<typename TN_>class alignment_of;		// ^̃ACg̎擾
template<int Align>class type_with_alignment;	// w肵ACgTCY̌^

//======================================================================
// class
IRIS_PRAGMA_WARNING_DISABLE(IRIS_CC_ARM, 1301)

/// alignment of
template<typename TN_>
class alignment_of
{
	template<typename TT_>struct type_hack
	{
		char	c;
		TT_		t;
	};
	template<unsigned A, unsigned S>struct alignment_logic
	{
		enum { value = A < S ? A : S };
	};
public:
	enum { value = alignment_logic< sizeof(type_hack<TN_>) - sizeof(TN_)
		, sizeof(TN_) >::value };
};
template<typename TN_>
class alignment_of<TN_&> : public alignment_of<TN_> {};

/// is aligned
template<int TAlign, int Align>
struct is_aligned
{
	enum { value = (TAlign >= Align) & (TAlign % Align) };
};

/// alignment of
template<int Align>
class type_with_alignment
{
	class alignment_dummy;
	typedef void *(function_ptr)(void);
	typedef int (alignment_dummy::* member_ptr);
	typedef int (alignment_dummy::* member_function_ptr)(void);

	template<bool found, size_t target, typename TT_>
	struct lower_alignment_helper : public iml::detail::true_type
	{
		typedef char	type;
	};
	template<size_t target, typename TT_>
	struct lower_alignment_helper<false, target, TT_>
	{
		enum { value = (alignment_of<TT_>::value == target) };
		typedef typename iml::type_select<value, TT_, char>::type	type;
	};
	template<size_t target>union lower_alignment
	{
		enum { found0 = false };
#define TYPE_WITH_ALIGNMENT_FIND_TYPE_(i, T)		\
	typename lower_alignment_helper<found##i, target, T>::type t##i;	\
	enum { IRIS_PP_CAT(found, IRIS_PP_INC(i)) = lower_alignment_helper<found##i, target, T>::value }

		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 0, char);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 1, short);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 2, int);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 3, long);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 4, long long);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 5, float);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 6, double);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 7, long double);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 8, void*);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_( 9, function_ptr);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_(10, member_ptr);
		TYPE_WITH_ALIGNMENT_FIND_TYPE_(11, member_function_ptr);
#undef TYPE_WITH_ALIGNMENT_FIND_TYPE_
	};

	union max_alignment
	{
		char				t0;
		short				t1;
		int					t2;
		long				t3;
		long long			t4;
		float				t5;
		double				t6;
		long double			t7;
		void*				t8;
		function_ptr		t9;
		member_ptr			t10;
		member_function_ptr	t11;
	};

	typedef lower_alignment<Align>	t1;
	typedef typename iml::type_select< is_aligned< alignment_of<t1>::value, Align >::value
		, t1, max_alignment >::type	align_t;
	enum { found = alignment_of<align_t>::value };

	IRIS_STATIC_ASSERT( found >= Align );
	IRIS_STATIC_ASSERT( found % Align == 0 );
public:
	typedef align_t	type;
};

IRIS_PRAGMA_WARNING_DEFAULT(IRIS_CC_ARM, 1301)


}	// end of namespace cpp0x

#endif
