//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_static_assert.h
 * @brief		cpp0x staic_assertt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_static_assert_H_
#define INCG_IRIS_cpp0x_static_assert_H_

//======================================================================
// include
#include "../preprocessor/PPString.h"

//================================================================================
// define

//======================================================================
// class
#if defined(__cplusplus)

#if	defined(_MSC_VER) && (_MSC_VER >= 1600)
#else

namespace cpp0x {
namespace detail
{
//================================================================================
// template

// HP aCC cannot deal with missing names for template value parameters
template <bool x> struct STATIC_ASSERTION_FAILURE;

template <> struct STATIC_ASSERTION_FAILURE<true> { enum { value = 1 }; };

// HP aCC cannot deal with missing names for template value parameters
template<int x> struct static_assert_test{};

}	// end of namespace detail
}	// end of namespace cpp0x

//================================================================================
// define
#if	(defined(_MSC_VER) && (_MSC_VER < 1200)) || defined(__BORLANDC__)
#  define IRIS_BUGGY_INTEGRAL_CONSTANT_EXPRESSIONS
#endif

#ifndef IRIS_BUGGY_INTEGRAL_CONSTANT_EXPRESSIONS

#  define static_assert( B, msg ) \
	typedef ::cpp0x::detail::static_assert_test< sizeof(::cpp0x::detail::STATIC_ASSERTION_FAILURE< (bool)( B ) >) > IRIS_PP_CAT(iris_static_assert_typedef_, __LINE__)

#else

// alternative enum based implementation
#  define static_assert( B, msg ) \
	enum { IRIS_PP_CAT(iris_static_assert_enum_, __LINE__) = sizeof(::cpp0x::detail::STATIC_ASSERTION_FAILURE< (bool)( B ) >) }

#endif

#endif

#else	// C
//#  define static_assert( B, msg )	do { enum { IRIS_PP_CAT(iris_static_assert_enum_, __LINE__) = sizeof( struct { char x[ (BOOL)( B ) ? 1 : -1 ]; } )	}; } while(0)
#  define static_assert( B, msg )	typedef char IRIS_PP_CAT(iris_static_assert_typedef_, __LINE__)[(BOOL)( B ) ? 1 : -1]
#endif

#define STATIC_ASSERT( ... )	static_assert( __VA_ARGS__, #__VA_ARGS__ )

#endif
