//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_regex.hpp
 * @brief		ice t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_regex_HPP_
#define INCG_IRIS_cpp0x_regex_HPP_

//======================================================================
// include
#if defined(_WIN32)
#  if	defined(_MSC_VER) && (_MSC_VER >= 1500) && (_MSC_FULL_VER >= 150030729)
#    include <regex>
#    include <string>
#    define _IRIS_SUPPORT_REGEX
#  else
#  endif
#else
#endif

namespace cpp0x
{

#if defined(_WIN32)
#  if	defined(_IRIS_SUPPORT_REGEX)
namespace tr1 = std::tr1;
#  else
#  endif
#else
#endif

}


#if defined(_WIN32)
#  if	defined(_IRIS_SUPPORT_REGEX)
namespace std {
namespace tr1
{

template<class _OutIt,
	class _BidIt,
	class _RxTraits,
	class _Elem> inline
	_OutIt regex_replace(_OutIt _Result,
		_BidIt _First, _BidIt _Last,
		const basic_regex<_Elem, _RxTraits>& _Re,
		const _Elem* _Fmt,
		regex_constants::match_flag_type _Flgs =
			regex_constants::match_default)
	{
		std::basic_string<_Elem> _fmt(_Fmt);
		return regex_replace(_Result, _First, _Last, _Re, _fmt, _Flgas);
	}


template<class _RxTraits,
	class _Elem>
	std::basic_string<_Elem> regex_replace(
		const std::basic_string<_Elem>& _Str,
		const basic_regex<_Elem, _RxTraits>& _Re,
		const _Elem* _Fmt,
		regex_constants::match_flag_type _Flgs =
			regex_constants::match_default)
	{
		std::basic_string<_Elem> _fmt(_Fmt);
		return regex_replace(_Str, _Re, _fmt, _Flgs);
	}
}
}

#  else
#  endif
#else
#endif

#endif
