//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_enable_if.hpp
 * @brief		enable_if t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_enable_if_HPP_
#define INCG_IRIS_cpp0x_enable_if_HPP_

//======================================================================
// include
#include "cpp0x_nullptr.h"

//======================================================================
// extern
namespace cpp0x
{
#if defined(__cplusplus0x)
	namespace enabler
	{
		extern void *	value;
	}
#else
	namespace detail
	{
		template<typename TN>
		struct enabler_t
		{
			static void*	value;
		};

		template<typename TN>void*	enabler_t<TN>::value = nullptr;
	}
	typedef detail::enabler_t<void>	enabler;
#endif
}

//======================================================================
// struct
#if !defined(__cplusplus0x)
template<bool B, class TC = void>
struct enable_if
{
	typedef TC	type;
};
template<class TC>
struct enable_if<false, TC> {};

#endif

template<class COND, class TC = void>
struct enable_if_t : public enable_if<COND::value, TC> {};

template<bool B, class TC = void>
struct disable_if : public enable_if<!B, TC> {};

template<class COND, class TC = void>
struct disable_if_t : public disable_if<COND::value, TC> {};

// lazzuy
namespace cpp0x {
namespace detail
{

template<class T>
class typedefined_enable_if_impl
{
	template<class TC>
	static int	validate_type_(void);

	template<class TC, bool=true>
	struct impl {};

	template<class TC>
	struct impl<TC
		, ( sizeof( validate_type_<typename TC::type>() ) > 0) >
	{
		typedef typename TC::type	type;
	};
public:
	typedef typename impl<T>::type	type;
};

}

template<bool B, class TC = void>
struct typedefined_enable_if
	: public cpp0x::detail::typedefined_enable_if_impl<TC>
{
};

template<class TC>
struct typedefined_enable_if<false, TC> {};

template<class COND, class TC = void>
struct typedefined_enable_if_t : public typedefined_enable_if<COND::value, TC> {};

}


#endif
