//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_constexpr.h
 * @brief		c++0x constexpr t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_constexpr_H_
#define INCG_IRIS_cpp0x_constexpr_H_

//======================================================================
// include

#ifndef _IRIS_HAS_CONSTEXPR
#  if	IRIS_GNUC_AT_LEAST(4, 6) && defined(__GXX_EXPERIMENTAL_CXX0X__)
#    define _IRIS_HAS_CONSTEXPR	1
#  else
#    define _IRIS_HAS_CONSTEXPR	0
#  endif
#endif

#if _IRIS_HAS_CONSTEXPR
#  define	IRIS_CONSTEXPR				constexpr
#  define	IRIS_CONSTEXPR_OR_CONST		constexpr
#  define	constexpr_assert(x_)	STATIC_ASSERT(x_)	// constexpr ɂ static_assert ł͂
#else
#  define	IRIS_CONSTEXPR				
#  define	IRIS_CONSTEXPR_OR_CONST		const
#  define	constexpr_assert(x_)	IRIS_ASSERT(x_)
#endif

#endif
