//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXXAudio.cpp
 * @brief		XAudio t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXXAudio_CPP_

//======================================================================
// include
#include "AXXAudio.h"

#if	defined(_IRIS_SUPPORT_XAUDIO2)

namespace iris {
namespace ax {
namespace xaudio
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CXAudio::CXAudio(void)
: m_pXAudio2(nullptr)
, m_pMaterVoice(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CXAudio::~CXAudio(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CXAudio::Initialize(void)
{
	HRESULT hr;
#if (_WIN32_WINNT >= 0x0400 ) || defined(_WIN32_DCOM) // DCOM
	hr = CoInitializeEx(nullptr, COINIT_MULTITHREADED);
#else
	hr = CoInitialize(nullptr);
#endif
	if( FAILED(hr) ) return false;

	u32 flags = 0;
#ifdef _IRIS_DEBUG
	flags |= XAUDIO2_DEBUG_ENGINE;
#endif
	hr = XAudio2Create(&m_pXAudio2, flags);
	if( FAILED(hr) )
	{
		CoUninitialize();
		return false;
	}
	hr = m_pXAudio2->CreateMasteringVoice(&m_pMaterVoice);
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CXAudio::Release(void)
{
	if( m_pMaterVoice != nullptr )
	{
		m_pMaterVoice->DestroyVoice();
		m_pMaterVoice = nullptr;
	}
	if( m_pXAudio2 != nullptr )
	{
		IRIS_SAFE_RELEASE(m_pXAudio2);
		CoUninitialize();
	}
}

}	// end of namespace xaudio
}	// end of namespace ax
}	// end of namespace iris

#endif
